/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.dashboard.lang;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Locale;
import java.util.Map;
import kd.bos.eye.api.dashboard.lang.OrderedProperties;
import kd.bos.mservice.monitor.lang.LangContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DashboardLangResBundle {
    private static OrderedProperties prop = new OrderedProperties();
    private static Logger logger = LoggerFactory.getLogger(DashboardLangResBundle.class);

    private static void load() {
        InputStream in = null;
        InputStreamReader reader = null;
        try {
            in = DashboardLangResBundle.class.getResourceAsStream("/scripts/dashboard_en_US.properties");
            reader = new InputStreamReader(in, "UTF-8");
            prop.load(reader);
        }
        catch (Exception e) {
            logger.warn("DashboardLangResBundle.load error", (Throwable)e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    logger.warn("DashboardLangResBundle.load error", (Throwable)e);
                }
            }
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    logger.warn("DashboardLangResBundle.load error", (Throwable)e);
                }
            }
        }
    }

    public static String translateAll(String def) {
        try {
            if (def != null && DashboardLangResBundle.isNeedTranslate()) {
                for (Map.Entry<Object, Object> entry : prop.entrySet()) {
                    String key = (String)entry.getKey();
                    String val = (String)entry.getValue();
                    def = def.replaceAll(key, val);
                }
            }
        }
        catch (Exception e) {
            logger.error("Dashboard translate error", (Throwable)e);
        }
        return def;
    }

    public static String translate(String def) {
        try {
            if (DashboardLangResBundle.isNeedTranslate()) {
                Object val = prop.get(def);
                if (val == null) {
                    return def;
                }
                return def.replace(def, String.valueOf(val));
            }
        }
        catch (Exception e) {
            logger.error("Dashboard translate error", (Throwable)e);
        }
        return def;
    }

    public static boolean isNeedTranslate() {
        Locale locale = LangContext.getLocaleFromThreadTruck();
        return "en".equals(locale.getLanguage());
    }

    static {
        DashboardLangResBundle.load();
    }
}

