/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.dashboard.metrics.commom;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import java.util.TreeSet;
import java.util.regex.Pattern;
import kd.bos.armor.core.util.StringUtil;
import kd.bos.government.Constant;
import kd.bos.util.StringUtils;

public class MetricsUtils {
    private static final DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
    private static final int MAX_RANGE = Integer.getInteger("monitor.log.maxSearchRange", 5);

    public static Date getDate(String date, boolean isEnd) {
        LocalDateTime time = LocalDateTime.parse(date, formatter);
        if (isEnd) {
            LocalDateTime temp = time.plusWeeks(MAX_RANGE);
            time = time.isAfter(temp) ? temp : time;
        }
        Date dateNew = Date.from(time.atZone(ZoneId.systemDefault()).toInstant());
        return dateNew;
    }

    public static Date parseDate(String date) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        if (StringUtils.isEmpty((String)date)) {
            throw new RuntimeException("Pares date error: The date is empty!");
        }
        try {
            dateFormat.setTimeZone(TimeZone.getTimeZone("GMT+0"));
            return dateFormat.parse(date);
        }
        catch (ParseException var3) {
            throw new RuntimeException("Parser date error,", var3);
        }
    }

    public static int floatToInt(float f) {
        int i = 0;
        if ((double)f == Double.POSITIVE_INFINITY || (double)f == Double.NEGATIVE_INFINITY) {
            return i;
        }
        i = (int)(f * 10.0f + 5.0f) / 10;
        return i;
    }

    public static String[] getIndices(String indexPre, Date start, Date end) {
        ImmutableSet betweenTime = new TreeSet();
        try {
            SimpleDateFormat indexDateFormat = new SimpleDateFormat("yyyy-MM-dd");
            Calendar sCalendar = Calendar.getInstance();
            sCalendar.setTime(start);
            int year = sCalendar.get(1);
            int month = sCalendar.get(2);
            int day = sCalendar.get(5);
            sCalendar.set(year, month, day, 0, 0, 0);
            Calendar eCalendar = Calendar.getInstance();
            eCalendar.setTime(end);
            year = eCalendar.get(1);
            month = eCalendar.get(2);
            day = eCalendar.get(5);
            eCalendar.set(year, month, day, 0, 0, 0);
            while (sCalendar.before(eCalendar)) {
                betweenTime.add(indexPre + indexDateFormat.format(sCalendar.getTime()));
                sCalendar.add(6, 1);
            }
            betweenTime.add(indexPre + indexDateFormat.format(eCalendar.getTime()));
            if (betweenTime.size() > Constant.SEARCH_RANGE_MAX) {
                betweenTime = ImmutableSet.copyOf((Iterable)Iterables.limit(betweenTime, (int)Constant.SEARCH_RANGE_MAX));
            }
        }
        catch (Exception e) {
            return betweenTime.toArray(new String[0]);
        }
        return betweenTime.toArray(new String[0]);
    }

    public static String format(float value, String formatter) {
        DecimalFormat decimalFormat = null;
        decimalFormat = StringUtil.isNotEmpty((String)formatter) ? new DecimalFormat(formatter) : new DecimalFormat("#,##0.#");
        return decimalFormat.format(value);
    }

    public static boolean isValidIPAddress(String ipAddress) {
        if (ipAddress != null && !ipAddress.isEmpty()) {
            return Pattern.matches("^([1-9]|[1-9]\\d|1\\d{2}|2[0-4]\\d|25[0-5])(\\.(\\d|[1-9]\\d|1\\d{2}|2[0-4]\\d|25[0-5])){3}$", ipAddress);
        }
        return false;
    }
}

