/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.dashboard.metrics.impl;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.eye.api.dashboard.metrics.entity.ArmorCondition;
import kd.bos.eye.api.dashboard.metrics.entity.AverageRt;
import kd.bos.eye.api.dashboard.metrics.entity.ExtChartData;
import kd.bos.eye.api.dashboard.metrics.entity.Throughput;
import kd.bos.eye.api.dashboard.metrics.impl.IQueryEsDaoImpl;
import kd.bos.eye.spi.BaseChartData;
import kd.bos.eye.spi.BaseQueryParameter;
import kd.bos.eye.spi.IMetricsData;
import kd.bos.mservice.monitor.lang.LangRes;

public class IAromrDataImpl
implements IMetricsData {
    @Override
    public BaseChartData query(BaseQueryParameter parameter) {
        ExtChartData chartData = new ExtChartData();
        String start = parameter.getStartTime();
        String end = parameter.getEndTime();
        String metrics = parameter.getMetrics();
        ArmorCondition condition = new ArmorCondition();
        try {
            condition.setStart(condition.stringToDate(start));
            condition.setEnd(condition.stringToDate(end));
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        Map<String, String> extensionParameter = parameter.getExtensionParameter();
        if (extensionParameter != null && !extensionParameter.isEmpty()) {
            String appName = extensionParameter.get("appName");
            String instanceId = extensionParameter.get("instanceId");
            condition.setAppName(appName);
            condition.setInstanceId(instanceId);
        }
        ArrayList<String> legend = new ArrayList<String>(1);
        ArrayList<String> xData = new ArrayList<String>(16);
        HashMap<String, List<Object>> yData = new HashMap<String, List<Object>>(1);
        ArrayList<Long> data = new ArrayList<Long>(16);
        IQueryEsDaoImpl dao = new IQueryEsDaoImpl();
        switch (parameter.getMetrics()) {
            case "kd.armor.total.qps": {
                Double totalQps = dao.queryTotalRequest(condition);
                String val = String.valueOf(Math.round(totalQps));
                chartData.setText(val);
                break;
            }
            case "kd.armor.average.rt": {
                List<AverageRt> rtList = dao.queryAvgRt(condition);
                if (rtList.isEmpty()) break;
                String leg = LangRes.get((String)"IAromrDataImpl_0", (String)"Average Response Time", (Object[])new Object[0]);
                legend.add(leg);
                for (AverageRt rt : rtList) {
                    xData.add(rt.getTimeStr());
                    data.add(Math.round(rt.getAverageRt()));
                }
                yData.put(leg, data);
                chartData.setUnit("ms");
                break;
            }
            case "kd.armor.throughput": {
                List<Throughput> throughputList = dao.queryThroughput(condition);
                if (throughputList.isEmpty()) break;
                String leg = LangRes.get((String)"IAromrDataImpl_1", (String)"Throughput", (Object[])new Object[0]);
                legend.add(leg);
                for (Throughput throughput : throughputList) {
                    xData.add(throughput.getTimeStr());
                    data.add(Math.round(throughput.getThroughput()));
                }
                yData.put(leg, data);
                break;
            }
            case "kd.armor.average.rt.val": {
                Double avgRtVal = dao.queryAvgRtVal(condition);
                String strRtVal = String.valueOf(Math.round(avgRtVal));
                chartData.setTitle(LangRes.get((String)"IAromrDataImpl_2", (String)"Average Response Time(ms)", (Object[])new Object[0]));
                chartData.setText(strRtVal);
                chartData.setUnit("ms");
                break;
            }
            case "kd.armor.throughput.val": {
                Double avgThroughputVal = dao.queryThroughputVal(condition);
                String strThroughputValVal = String.valueOf(Math.round(avgThroughputVal));
                chartData.setText(strThroughputValVal);
            }
        }
        chartData.setLegend(legend);
        chartData.setxData(xData);
        chartData.setyData(yData);
        chartData.setMetrics(metrics);
        return chartData;
    }
}

