/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.dashboard.metrics.query.alarm;

import java.util.ArrayList;
import java.util.List;
import kd.bos.eye.api.alarm.config.metric.AlarmLevel;
import kd.bos.eye.api.dashboard.metrics.base.TextChartData;
import kd.bos.eye.spi.BaseQueryParameter;
import kd.bos.eye.spi.IMetricsData;
import kd.bos.government.metadata.MetadataFactory;
import kd.bos.government.metadata.Request;
import kd.bos.government.metadata.Result;
import kd.bos.government.metadata.db.DBRequest;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.monitor.lang.LangRes;
import kd.bos.util.StringUtils;

public class AlarmMetricsHandler
implements IMetricsData {
    private static final Log log = LogFactory.getLog(AlarmMetricsHandler.class);
    private static final String ALARM_TABLE = "t_monitor_alarm_record";
    private static final String RESTORE_STATUS = "OK";
    private static final String ALARM_STATUS = "ALARM";
    private static final String TOTAL_COUNT = "total";
    private static final String LOW_LEVEL = "LOW";
    private static final String SERIOUS_LEVEL = "SERIOUS";
    private static final String DISASTER_LEVEL = "DISASTER";

    private static String getLocalALARM_TEMPLATE() {
        return "<table style='width:100%;text-align: center;font-size:15px'><tr><th>" + LangRes.get((String)"AlarmMetricsHandler_0", (String)"Total", (Object[])new Object[0]) + "</th><th>" + LangRes.get((String)"AlarmMetricsHandler_1", (String)"Fatal", (Object[])new Object[0]) + "</th><th>" + LangRes.get((String)"AlarmMetricsHandler_2", (String)"Critical", (Object[])new Object[0]) + "</th><th>" + LangRes.get((String)"AlarmMetricsHandler_3", (String)"General", (Object[])new Object[0]) + "</th></tr><tr style='font-size:45px'><td style='color:#f13405;font-weight: bold'>total</td><td style='color:#d60606;font-weight: bold'>DISASTER</td><td style='color:#ff6c40;font-weight: bold'>SERIOUS</td><td style='color:#ff9900;font-weight: bold'>LOW</td></tr></table>";
    }

    @Override
    public TextChartData query(BaseQueryParameter parameter) {
        String instanceId;
        String text = "";
        int low_level_count = 0;
        int serious_level_count = 0;
        int disaster_level_count = 0;
        AlarmLevel.DISASTER.getCode();
        int alarmItems = 0;
        TextChartData textChartData = new TextChartData();
        StringBuilder sql = new StringBuilder("select  fid,flevel from ");
        sql.append(ALARM_TABLE).append(" where FSTATE = '").append(ALARM_STATUS).append("'");
        String appName = parameter.getExtensionParameter().get("appName");
        if (StringUtils.isNotEmpty((String)appName)) {
            sql.append(" and fappname ='").append(appName).append("'");
        }
        if (StringUtils.isNotEmpty((String)(instanceId = parameter.getExtensionParameter().get("instanceId")))) {
            sql.append(" and fip ='").append(instanceId).append("'");
        }
        try {
            ArrayList queryList = new ArrayList(10);
            DBRequest dbRequest = new DBRequest();
            dbRequest.setQueryRequest(new DBRequest.QueryRequest(sql.toString(), queryList));
            List returnList = MetadataFactory.getStatement().executeQuery((Request)dbRequest);
            alarmItems = returnList.size();
            for (Result result : returnList) {
                String flevel;
                switch (flevel = result.getString("flevel")) {
                    case "LOW": {
                        ++low_level_count;
                        break;
                    }
                    case "SERIOUS": {
                        ++serious_level_count;
                        break;
                    }
                    case "DISASTER": {
                        ++disaster_level_count;
                        break;
                    }
                }
            }
        }
        catch (Exception e) {
            log.error("Alarm query error={}", (Object)e.getMessage());
        }
        String chartText = AlarmMetricsHandler.getLocalALARM_TEMPLATE().replaceAll(TOTAL_COUNT, String.valueOf(alarmItems)).replaceAll(DISASTER_LEVEL, String.valueOf(String.valueOf(disaster_level_count))).replaceAll(SERIOUS_LEVEL, String.valueOf(serious_level_count)).replaceAll(LOW_LEVEL, String.valueOf(low_level_count));
        textChartData.setText(chartText);
        textChartData.setUnit("");
        return textChartData;
    }
}

