/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.dashboard.metrics.query.api;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dc.utils.MCApiUtil;
import kd.bos.eye.api.dashboard.metrics.query.api.APISlowTopNMetricsHandler;
import kd.bos.govern.StorageType;
import kd.bos.government.metadata.MetadataFactory;
import kd.bos.government.metadata.Request;
import kd.bos.government.metadata.Result;
import kd.bos.government.metadata.db.DBHelper;
import kd.bos.government.metadata.db.DBRequest;
import kd.bos.government.metadata.db.Row;
import kd.bos.government.storage.Storage;
import kd.bos.government.storage.StorageFactory;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.JSONUtils;
import kd.bos.util.StringUtils;

public class APITopNQuery {
    private static final Log log = LogFactory.getLog(APISlowTopNMetricsHandler.class);
    private static final String MC_API_GET_MC_DATA = "/kapi/app/mc/DataSaveGetService";
    private static final String CLUSTER_NAME = Instance.getClusterName() + "apiMetadata";
    private static final StorageType storageType = StorageType.getStorageType((String)System.getProperty("apm.gov.invoke.report.storage.type", "elasticsearch"));
    protected static final Storage storage = StorageFactory.getStorage((StorageType)storageType);
    private static final String TIME = "time";
    private static final String COUNT = "count";
    private static final String SIGNATURE = "signature";
    private static final String TOPN_PARA_KEY = "topn";
    private static final String TOP_TYPE_PARA_KEY = "topType";
    private static final String TOP_HOT_API_TYPE = "hot";
    private static final String TOP_SLOW_API_TYPE = "slow";
    private static final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public static Map<String, Object> query(Date start, Date end, String topTypeInput, int topN) {
        String apiName;
        HashMap<String, Object> retMap = new HashMap<String, Object>(3);
        HashMap<String, String> map = new HashMap<String, String>(3);
        map.put("DCID", CLUSTER_NAME);
        ArrayList<Map<String, Object>> ret = new ArrayList<Map<String, Object>>(32);
        String name = apiName = null;
        boolean notEmpty = StringUtils.isNotEmpty(name);
        String apiType = "";
        String topType = topTypeInput;
        boolean dbIsConfigured = false;
        try {
            if (DBHelper.dbIsConfigured()) {
                dbIsConfigured = true;
            }
            HashSet<String> apiSet = new HashSet<String>(16);
            Map<String, String> appNameConfigs = APITopNQuery.queryApi(name, apiSet);
            if (!notEmpty && !apiSet.isEmpty()) {
                apiName = String.join((CharSequence)"@@", apiSet);
            }
            Map stats = storage.apiCallStats(start, end != null ? end : new Date(), apiName, apiType);
            if (dbIsConfigured) {
                Map<String, Map<String, Object>> dbMap = APITopNQuery.getApiMetadataFromDB(stats, name);
                APITopNQuery.covert(dbMap, stats);
                for (Map.Entry<String, Map<String, Object>> entry : dbMap.entrySet()) {
                    Map<String, Object> apiMap = entry.getValue();
                    if (apiMap.get(COUNT) == null) continue;
                    if (StringUtils.isNotEmpty((String)apiType)) {
                        String type = (String)apiMap.get("type");
                        if (!apiType.equals(type)) continue;
                        ret.add(apiMap);
                        continue;
                    }
                    ret.add(apiMap);
                }
            } else {
                List list = (List)MCApiUtil.getMCAPIInfo((String)MC_API_GET_MC_DATA, (boolean)true, null, map);
                int subCount = Integer.getInteger("monitor.apicall.limit.db.count", 10000);
                int size = list.size() > subCount ? subCount : list.size();
                list = list.subList(0, size);
                for (String mapStr : list) {
                    Map cast;
                    if (StringUtils.isEmpty((String)mapStr) || "null".equalsIgnoreCase(mapStr) || !(cast = (Map)JSONUtils.cast((String)mapStr, Map.class)).containsKey(SIGNATURE)) continue;
                    APITopNQuery.setStats(cast, stats);
                    if (StringUtils.isNotEmpty((String)apiType)) {
                        String type = (String)cast.get("type");
                        if (!apiType.equals(type)) continue;
                        ret.add(cast);
                        continue;
                    }
                    ret.add(cast);
                }
            }
            APITopNQuery.formatData(ret, appNameConfigs);
            if (topType.equals("slowAPI")) {
                APITopNQuery.sort(ret, TIME);
                retMap.put(TIME, APITopNQuery.topN(ret, TIME, topN));
            } else if (topType.equals("hotAPI")) {
                APITopNQuery.sort(ret, COUNT);
                retMap.put(COUNT, APITopNQuery.topN(ret, COUNT, topN));
            }
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
        return retMap;
    }

    private static void formatData(List<Map<String, Object>> list, Map<String, String> config) {
        for (Map<String, Object> apiMap : list) {
            String apiName = apiMap.get(SIGNATURE).toString();
            String desc = config.get(apiName);
            if (desc == null) continue;
            apiMap.put("desc", desc);
        }
    }

    private static Map<String, Map<String, Object>> getApiMetadataFromDB(Map<String, Map<String, Object>> statsMap, String name) {
        int apiCount = Integer.getInteger("monitor.apicall.limit.db.count", 2000);
        boolean isAppSplit = Instance.isAppSplit();
        DBRequest dbRequest = new DBRequest();
        ArrayList<String> queryList = new ArrayList<String>(1);
        StringBuilder querySqlBuilder = new StringBuilder();
        querySqlBuilder.append("select top ").append(apiCount).append(",0 a.fapiname,a.ftype,a.fappid from t_monitor_api_metadata a  where a.fclustername = ? ").append(isAppSplit ? "and a.fappid !=' '" : "");
        if (StringUtils.isNotEmpty((String)name)) {
            querySqlBuilder.append(" and fapiname like '%").append(name).append("%'");
        }
        queryList.add(Instance.getClusterName());
        dbRequest.setQueryRequest(new DBRequest.QueryRequest(querySqlBuilder.toString(), queryList));
        List retunList = MetadataFactory.getStatement().executeQuery((Request)dbRequest);
        HashMap<String, Map<String, Object>> resultMap = new HashMap<String, Map<String, Object>>(8);
        for (Result row : retunList) {
            HashMap<String, Object> map = new HashMap<String, Object>(4);
            String apiName = row.getString("fapiname");
            String type = row.getString("ftype");
            String appId = row.getString("fappid");
            map.put(SIGNATURE, apiName);
            map.put("type", type);
            map.put("appId", appId);
            Map<String, Object> statMap = statsMap.get(apiName);
            if (statMap != null) {
                map.put(COUNT, statMap.get(COUNT));
                map.put(TIME, statMap.get(TIME));
            }
            resultMap.put(apiName, map);
        }
        return resultMap;
    }

    private static void covert(Map<String, Map<String, Object>> dbMap, Map<String, Map<String, Object>> statsMap) {
        HashMap<String, Map<String, Object>> addMap = new HashMap<String, Map<String, Object>>();
        for (Map.Entry<String, Map<String, Object>> entry : statsMap.entrySet()) {
            String key = entry.getKey();
            if (dbMap.containsKey(key)) continue;
            Map<String, Object> signatureMap = entry.getValue();
            signatureMap.put(SIGNATURE, key);
            addMap.put(key, signatureMap);
        }
        dbMap.putAll(addMap);
    }

    private static void setStats(Map<String, Object> sourceMap, Map<String, Map<String, Object>> statsMap) {
        for (Map.Entry<String, Map<String, Object>> next : statsMap.entrySet()) {
            String key = next.getKey();
            Map<String, Object> value = next.getValue();
            if (!sourceMap.get(SIGNATURE).toString().equals(key)) continue;
            sourceMap.putAll(value);
            break;
        }
    }

    private static void sort(List<Map<String, Object>> list, String type) {
        list.sort((o1, o2) -> {
            Object type2;
            Object type1 = o1.get(type);
            if (type1 == null) {
                type1 = 0.0;
            }
            if ((type2 = o2.get(type)) == null) {
                type2 = 0.0;
            }
            int a = ((Number)type1).intValue();
            int b = ((Number)type2).intValue();
            return b - a;
        });
    }

    private static Map<String, Object> topN(List<Map<String, Object>> list, String type, int topN) {
        HashMap<String, Object> temp = new HashMap<String, Object>(2);
        int min = Math.min(list.size(), topN);
        Object[] xAxis = new Object[min];
        Object[] yAxis = new Object[min];
        for (int i = 0; i < min; ++i) {
            Map<String, Object> map = list.get(i);
            Object o = map.get(type);
            xAxis[i] = o == null ? 0.0 : (double)((Number)o).intValue();
            Object desc = map.get("desc");
            yAxis[i] = desc != null && StringUtils.isNotEmpty((String)desc.toString()) ? desc : map.get(SIGNATURE);
        }
        temp.put("xAxis", xAxis);
        temp.put("yAxis", yAxis);
        return temp;
    }

    private static Map<String, String> queryApi(String apiName, Set<String> apiSet) {
        boolean filterApiName = StringUtils.isNotEmpty((String)apiName);
        StringBuilder sql = new StringBuilder("select fapiname,fdesc from t_monitor_api_metadata where fclustername = ? ");
        if (filterApiName) {
            sql.append("and fapiname like '%").append(apiName).append("%' or fdesc like '%").append(apiName).append("%'");
        } else {
            sql.append(" and fdesc is not null ");
        }
        DBRequest dbRequest = new DBRequest();
        dbRequest.setQueryRequest(new DBRequest.QueryRequest(sql.toString(), Collections.singletonList(Instance.getClusterName())));
        List results = MetadataFactory.getStatement().executeQuery((Request)dbRequest);
        HashMap<String, String> result = new HashMap<String, String>(results.size());
        results.forEach(key -> {
            Object desc;
            Row row = (Row)key;
            Map map = row.getMap();
            String appName = map.get("fapiname").toString();
            if (filterApiName) {
                apiSet.add(apiName);
            }
            if ((desc = map.get("fdesc")) != null) {
                result.put(appName, String.valueOf(desc));
            }
        });
        return result;
    }

    private int getInputTopNValue(String topNStr) {
        int defaultTopN = 5;
        try {
            int inputTopN;
            if (StringUtils.isNotEmpty((String)topNStr) && (inputTopN = Integer.getInteger(topNStr).intValue()) <= 10 && inputTopN >= 1) {
                defaultTopN = inputTopN;
            }
        }
        catch (Exception e) {
            log.error("Dashborad --> TopN N's value not set or set error ,so use default 5.");
        }
        return defaultTopN;
    }
}

