/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.dashboard.metrics.query.dtx;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import kd.bos.eye.api.dashboard.metrics.base.TextChartData;
import kd.bos.eye.api.dtx.dao.reporter.realtime.OverViewDao;
import kd.bos.eye.api.dtx.entity.reporter.OverViewInfo;
import kd.bos.eye.api.dtx.entity.reporter.ReporterSearchParam;
import kd.bos.eye.spi.BaseQueryParameter;
import kd.bos.eye.spi.IMetricsData;
import kd.bos.eye.util.StringFormatUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.monitor.lang.LangRes;

public class DTXMetricsHandler
implements IMetricsData {
    private static final String TYPE_KEY = "realTime";
    private static final Log log = LogFactory.getLog(DTXMetricsHandler.class);
    private final SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
    private static final String DTX_TEMPLATE = "<table border='1' style='width:100%;text-align:left;font-size:15px;border-color: #6fb0f347;border-collapse: collapse;'><tbody style=''><tr><td style='width:12%'>@%0%</td><td colspan='3'  style='font-size: 20px;font-weight: 400;color: #409eff;'>total_count</td></tr><tr><td  style='width:12%'>@%1%</td><td  style='width:25%;font-size: 20px;font-weight: 400;color: #67C23D;' >success_count</td><td  style='width:12%'>@%2%</td><td  style='width:38%;font-size: 20px;font-weight: 400;color:red;'>failure_count</td></tr><tr><td style=''>@%3%</td><td style='font-size: 20px;font-weight: 400;color: #f56c6c;'>revoke_count</td><td>@%4%</td><td style='font-size: 20px;font-weight: 400;color: #d8f110;'>toRepair_count</td></tr><tr><td>@%5%</td><td style='font-size: 20px;font-weight: 400;color: #f9b946;'>autRepair_count</td><td>@%6%</td><td style='font-size: 20px;font-weight: 400;color: #f9b946;'>manualRepair_count</td></tr></tbody></table>";

    private static String getDtxTemplate() {
        String msg0 = LangRes.get((String)"DTXMetricsHandler_0", (String)"Total:", (Object[])new Object[0]);
        String msg1 = LangRes.get((String)"DTXMetricsHandler_1", (String)"Success:", (Object[])new Object[0]);
        String msg2 = LangRes.get((String)"DTXMetricsHandler_2", (String)"Failure:", (Object[])new Object[0]);
        String msg3 = LangRes.get((String)"DTXMetricsHandler_3", (String)"Rollback:", (Object[])new Object[0]);
        String msg4 = LangRes.get((String)"DTXMetricsHandler_4", (String)"Unresolved:", (Object[])new Object[0]);
        String msg5 = LangRes.get((String)"DTXMetricsHandler_5", (String)"Automatic Repair:", (Object[])new Object[0]);
        String msg6 = LangRes.get((String)"DTXMetricsHandler_6", (String)"Manual Repair:", (Object[])new Object[0]);
        return StringFormatUtils.format(DTX_TEMPLATE, msg0, msg1, msg2, msg3, msg4, msg5, msg6);
    }

    @Override
    public TextChartData query(BaseQueryParameter parameter) {
        TextChartData textChartData = new TextChartData();
        textChartData.setUnit("");
        OverViewDao overViewDao = new OverViewDao();
        try {
            ReporterSearchParam reporterSearchParam = new ReporterSearchParam();
            reporterSearchParam.setReporterType(TYPE_KEY);
            Calendar c = Calendar.getInstance(TimeZone.getTimeZone("GMT+08:00"));
            Date starDate = c.getTime();
            String start = this.formatter.format(starDate);
            c.add(5, 1);
            Date endDate = c.getTime();
            String end = this.formatter.format(endDate);
            String[] range = new String[]{start, end};
            reporterSearchParam.setDateRange(range);
            reporterSearchParam.setType(1);
            reporterSearchParam.setAccountId("");
            reporterSearchParam.setSceneId("");
            reporterSearchParam.setTenantId("");
            reporterSearchParam.setDataType("");
            reporterSearchParam.setAccountId("");
            reporterSearchParam.setXid("");
            OverViewInfo info = overViewDao.getOverViewInfo(reporterSearchParam);
            StringBuilder infoBuilder = new StringBuilder();
            String infoText = DTXMetricsHandler.getDtxTemplate().replaceAll("total_count", String.valueOf(info.getSuccess())).replaceAll("success_count", String.valueOf(info.getSuccess())).replaceAll("failure_count", String.valueOf(info.getException())).replaceAll("revoke_count", String.valueOf(info.getRollback())).replaceAll("toRepair_count", String.valueOf(info.getNotRepair())).replaceAll("autRepair_count", String.valueOf(info.getAutoRepair())).replaceAll("manualRepair_count", String.valueOf(info.getManualRepair()));
            textChartData.setText(infoText);
            textChartData.setUnit("");
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
        return textChartData;
    }
}

