/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.dashboard.metrics.query.memory;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.eye.api.dashboard.metrics.commom.MetricsUtils;
import kd.bos.eye.api.dashboard.metrics.entity.ExtChartData;
import kd.bos.eye.api.dashboard.metrics.entity.MetricsCondition;
import kd.bos.eye.api.dashboard.metrics.impl.IMetricsEsDaoImpl;
import kd.bos.eye.spi.BaseChartData;
import kd.bos.eye.spi.BaseQueryParameter;
import kd.bos.eye.spi.IMetricsData;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.monitor.lang.LangRes;
import kd.bos.util.StringUtils;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.elasticsearch.search.aggregations.metrics.max.MaxAggregationBuilder;
import org.elasticsearch.search.aggregations.metrics.max.ParsedMax;
import org.elasticsearch.search.aggregations.metrics.min.MinAggregationBuilder;
import org.elasticsearch.search.aggregations.metrics.min.ParsedMin;
import org.elasticsearch.search.builder.SearchSourceBuilder;

public class MemoryFullGCHandler
implements IMetricsData {
    private static final Log log = LogFactory.getLog(MemoryFullGCHandler.class);
    private static final String TIMESTAMP = "timestamp";
    private static final String INSTANCE_KEY = "instanceId";
    private static final String APPNAME_KEY = "appName";
    private static final String PERCENT_INTEGER_KEY = "percent";
    private static final String UNIT_TEXT = "unit";
    private static final String TABLE_TD_TMP = "<span style='color:red;'>value</span>";
    private static final String TABLE_TD_TMP_KEY = "value";
    private static final String ZERO_KEY = "0";
    private static final String ONE_KEY = "1";
    private static final String TIP_HTML = "<span title='instanceId' style='cursor:pointer;'>instanceId</span>";

    private static List<String> getTableLend() {
        String lend0 = LangRes.get((String)"MemoryFullGCHandler_0", (String)"App Name", (Object[])new Object[0]);
        String lend1 = LangRes.get((String)"MemoryFullGCHandler_1", (String)"Instance", (Object[])new Object[0]);
        String lend2 = LangRes.get((String)"MemoryFullGCHandler_2", (String)"Times", (Object[])new Object[0]);
        String lend4 = LangRes.get((String)"MemoryFullGCHandler_4", (String)"Average Duration", (Object[])new Object[0]);
        return Arrays.asList(lend0, lend1, lend2, lend4);
    }

    private static String getTableTdTmpTime() {
        return "<span style='color:red;'>value " + LangRes.get((String)"MemoryFullGCHandler_5", (String)"milliseconds", (Object[])new Object[0]) + "</span>";
    }

    @Override
    public BaseChartData query(BaseQueryParameter parameter) {
        String start = parameter.getStartTime();
        String end = parameter.getEndTime();
        ExtChartData extChartData = new ExtChartData();
        HashMap<String, List<Object>> yData = new HashMap<String, List<Object>>();
        try {
            String appName = parameter.getExtensionParameter().get(APPNAME_KEY);
            String instanceId = parameter.getExtensionParameter().get(INSTANCE_KEY);
            MetricsCondition condition = new MetricsCondition();
            if (StringUtils.isNotEmpty((String)appName)) {
                condition.setAppName(appName);
            }
            if (StringUtils.isNotEmpty((String)instanceId)) {
                condition.setInstanceId(instanceId);
            }
            condition.setMetrics("kd.metrics.jvm.gc.PS-MarkSweep.count");
            ArrayList<String> includes = new ArrayList<String>(4);
            includes.add("kd.metrics.jvm.gc.PS-MarkSweep.count");
            includes.add(TIMESTAMP);
            includes.add("ip");
            includes.add(INSTANCE_KEY);
            condition.setIncludeFieldsResult(includes.toArray(new String[includes.size()]));
            condition.setPageSize(0);
            condition.setStart(condition.stringToDate(start));
            condition.setEnd(condition.stringToDate(end));
            IMetricsEsDaoImpl esDao = new IMetricsEsDaoImpl();
            SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
            sourceBuilder.size(0);
            sourceBuilder.trackTotalHits(true);
            TermsAggregationBuilder builder = (TermsAggregationBuilder)AggregationBuilders.terms((String)"fullGC").field("instanceId.keyword");
            builder.size(10000);
            AggregatorFactories.Builder builderSub = AggregatorFactories.builder();
            MaxAggregationBuilder maxCount = (MaxAggregationBuilder)AggregationBuilders.max((String)"maxCount").field("kd.metrics.jvm.gc.PS-MarkSweep.count");
            MinAggregationBuilder minCount = (MinAggregationBuilder)AggregationBuilders.min((String)"minCount").field("kd.metrics.jvm.gc.PS-MarkSweep.count");
            MinAggregationBuilder minTime = (MinAggregationBuilder)AggregationBuilders.min((String)"minTime").field("kd.metrics.jvm.gc.PS-MarkSweep.time");
            MaxAggregationBuilder maxTime = (MaxAggregationBuilder)AggregationBuilders.max((String)"maxTime").field("kd.metrics.jvm.gc.PS-MarkSweep.time");
            builderSub.addAggregator((AggregationBuilder)maxCount);
            builderSub.addAggregator((AggregationBuilder)minCount);
            builderSub.addAggregator((AggregationBuilder)minTime);
            builderSub.addAggregator((AggregationBuilder)maxTime);
            builder.subAggregations(builderSub);
            sourceBuilder.aggregation((AggregationBuilder)builder);
            SearchResponse response = esDao.queryMetricsRange(condition, sourceBuilder);
            Terms terms = (Terms)response.getAggregations().get("fullGC");
            int i = 1;
            for (Terms.Bucket bucket : terms.getBuckets()) {
                String instId = bucket.getKeyAsString();
                String appNameVal = instId.substring(0, instId.lastIndexOf("-"));
                Map maps = bucket.getAggregations().getAsMap();
                double minCountVal = ((ParsedMin)maps.get("minCount")).value();
                double maxCountVal = ((ParsedMax)maps.get("maxCount")).value();
                double maxTimeVal = ((ParsedMax)maps.get("maxTime")).value();
                double minTimeVal = ((ParsedMin)maps.get("minTime")).value();
                int minCountValInt = MetricsUtils.floatToInt((float)minCountVal);
                int maxCountValInt = MetricsUtils.floatToInt((float)maxCountVal);
                int maxTimeValInt = MetricsUtils.floatToInt((float)maxTimeVal);
                int minTimeValInt = MetricsUtils.floatToInt((float)minTimeVal);
                int timeInterval = maxTimeValInt - minTimeValInt;
                ArrayList<String> list = new ArrayList<String>();
                list.add(TIP_HTML.replaceAll(INSTANCE_KEY, appNameVal));
                list.add(TIP_HTML.replaceAll(INSTANCE_KEY, instId));
                String countStr = String.valueOf(maxCountValInt - minCountValInt);
                String avgTimeStr = ZERO_KEY;
                avgTimeStr = ZERO_KEY.equals(countStr) ? ZERO_KEY : String.valueOf(timeInterval / (maxCountValInt - minCountValInt));
                String td2 = TABLE_TD_TMP.replaceAll(TABLE_TD_TMP_KEY, countStr);
                String td4 = MemoryFullGCHandler.getTableTdTmpTime().replaceAll(TABLE_TD_TMP_KEY, avgTimeStr);
                list.add(td2);
                list.add(td4);
                yData.put(String.valueOf(i), list);
                ++i;
            }
        }
        catch (Exception e) {
            log.error("Count fullGC query error={}", (Object)e.getMessage());
        }
        extChartData.setyData(yData);
        extChartData.setLegend(MemoryFullGCHandler.getTableLend());
        return extChartData;
    }
}

