/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.dashboard.metrics.query.mservice;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import kd.bos.eye.api.dashboard.metrics.commom.MetricsUtils;
import kd.bos.eye.api.dashboard.metrics.entity.ExtChartData;
import kd.bos.eye.api.dashboard.metrics.entity.MetricsCondition;
import kd.bos.eye.api.dashboard.metrics.entity.MetricsResultData;
import kd.bos.eye.api.dashboard.metrics.impl.IMetricsEsDaoImpl;
import kd.bos.eye.spi.BaseChartData;
import kd.bos.eye.spi.BaseQueryParameter;
import kd.bos.eye.spi.IMetricsData;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.monitor.lang.LangRes;
import kd.bos.util.StringUtils;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.SortOrder;

public class ServiceHealthHandler
implements IMetricsData {
    private static final Log log = LogFactory.getLog(ServiceHealthHandler.class);
    private static final String TIMESTAMP = "timestamp";
    private static final String INSTANCE_KEY = "instanceId";
    private static final String APPNAME_KEY = "appName";
    private static final String PERCENT_INTEGER_KEY = "percent";
    private static final String UNIT_TEXT = "unit";
    public static final String METRIC_INDEX_KEYWORD = "-metrics-";
    private static final String TABLE_TD_TMP_RED = "<span style='color:red;'>value</span>";
    private static final String TABLE_TD_TMP_GREEN = "<span style='color:green;'>value</span>";
    private static final String TABLE_TD_TMP_WARN = "<span style='color:green;'>value</span>";
    private static final String TABLE_TD_TMP_KEY = "value";
    private static final String GC_COUNT_KEY = "gcCount";
    private static final String GC_MAX_TIME_KEY = "maxTime";
    private static final String GC_AVG_TIME_KEY = "avgTime";
    private static final String ZERO_KEY = "0";
    private static final String INSTANCE_ID_DEFAULT_KEY = "empty";
    private static final String HEALTH_TEMPLATE = "<table style='width:100%;text-align: center;font-size:15px'><tr><th>\u5b9e\u4f8b</th><th>\u5065\u5eb7\u72b6\u6001</th></tr><tr style='font-size:45px'><td style='color:#f13405;font-weight: bold'>instanceId<td style=health</td><td style='color:#cssColor;font-weight: bold'>health</td></tr></table>";
    private static final String TIP_HTML = "<span title='instanceId' style='cursor:pointer;'>instanceId</span>";

    private static List<String> getTableLend() {
        String lend0 = LangRes.get((String)"ServiceHealthHandler_0", (String)"Service Name", (Object[])new Object[0]);
        String lend1 = LangRes.get((String)"ServiceHealthHandler_1", (String)"Service Instance", (Object[])new Object[0]);
        String lend2 = LangRes.get((String)"ServiceHealthHandler_2", (String)"Health Status", (Object[])new Object[0]);
        return Arrays.asList(lend0, lend1, lend2);
    }

    @Override
    public BaseChartData query(BaseQueryParameter parameter) {
        Calendar now = Calendar.getInstance();
        Date endD = now.getTime();
        now.add(13, -30);
        Date startD = now.getTime();
        ExtChartData extChartData = new ExtChartData();
        try {
            String appName = parameter.getExtensionParameter().get(APPNAME_KEY);
            String instanceId = parameter.getExtensionParameter().get(INSTANCE_KEY);
            MetricsCondition condition = new MetricsCondition();
            if (StringUtils.isNotEmpty((String)appName)) {
                condition.setAppName(appName);
            }
            if (StringUtils.isNotEmpty((String)instanceId)) {
                condition.setInstanceId(instanceId);
            }
            condition.setMetrics("kd.metrics.mservice.nodehealth");
            ArrayList<String> includes = new ArrayList<String>(4);
            includes.add("kd.metrics.mservice.nodehealth");
            condition.setIncludeFieldsResult(includes.toArray(new String[includes.size()]));
            condition.setPageSize(10000);
            condition.setStart(startD);
            condition.setEnd(endD);
            SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
            sourceBuilder.size(10000);
            sourceBuilder.sort(TIMESTAMP, SortOrder.DESC);
            sourceBuilder.trackTotalHits(true);
            IMetricsEsDaoImpl dao = new IMetricsEsDaoImpl();
            List<MetricsResultData> dataList = dao.queryMetricsRange(condition);
            Collections.reverse(dataList);
            HashSet uniSet = new HashSet();
            dataList.forEach(data -> uniSet.add(data.getInstanceId()));
            int i = 1;
            HashMap<String, List<Object>> yData = new HashMap<String, List<Object>>(16);
            for (String instanceIdVal : uniSet) {
                ArrayList<String> list = new ArrayList<String>(16);
                for (MetricsResultData metricsResultData : dataList) {
                    if (!instanceIdVal.equals(metricsResultData.getInstanceId())) continue;
                    list.add(TIP_HTML.replaceAll(INSTANCE_KEY, metricsResultData.getAppName()));
                    list.add(TIP_HTML.replaceAll(INSTANCE_KEY, instanceIdVal));
                    String healthInfo = this.getHealthInf(metricsResultData.getVal());
                    if (metricsResultData.getVal() >= 40.0) {
                        list.add(TABLE_TD_TMP_RED.replace(TABLE_TD_TMP_KEY, healthInfo));
                        break;
                    }
                    list.add("<span style='color:green;'>value</span>".replace(TABLE_TD_TMP_KEY, healthInfo));
                    break;
                }
                yData.put(String.valueOf(i), list);
                ++i;
            }
            extChartData.setLegend(ServiceHealthHandler.getTableLend());
            extChartData.setyData(yData);
        }
        catch (Exception e) {
            log.error("Count fullGC query error={}", (Object)e.getMessage());
        }
        return extChartData;
    }

    private String getHealthInf(double level) {
        int intLevel = MetricsUtils.floatToInt((float)level);
        String info = "";
        switch (intLevel) {
            case 0: {
                info = LangRes.get((String)"ServiceHealthHandler_3", (String)"Initialize", (Object[])new Object[0]);
                break;
            }
            case 10: {
                info = LangRes.get((String)"ServiceHealthHandler_4", (String)"Healthy", (Object[])new Object[0]);
                break;
            }
            case 40: {
                info = LangRes.get((String)"ServiceHealthHandler_5", (String)"Busy", (Object[])new Object[0]);
                break;
            }
            case 100: {
                info = LangRes.get((String)"ServiceHealthHandler_6", (String)"Overload", (Object[])new Object[0]);
                break;
            }
            default: {
                info = LangRes.get((String)"ServiceHealthHandler_7", (String)"Error", (Object[])new Object[0]);
            }
        }
        return info;
    }
}

