/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.dashboard.metrics.query.sessions;

import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.RequestContextInfo;
import kd.bos.dc.api.model.Account;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.elect.ElectFactory;
import kd.bos.elect.Elector;
import kd.bos.elect.ElectorListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metric.MetricSystem;

public class OnlineSessionCollector {
    private static final Log logger = LogFactory.getLog(OnlineSessionCollector.class);
    private static ConcurrentHashMap<String, LastRecord> recordMap = new ConcurrentHashMap();
    private static long LIMIT_INTERVAL_SECONDS = 2L;
    private static final String TOTAL_NAME = "kd.metrics.onlineSession.total";
    private static final String WEB_NAME = "kd.metrics.onlineSession.web";
    private static final String MOBILE_NAME = "kd.metrics.onlineSession.mobile";
    private static final String COLLECT_ENABLE = "monitor.onlinesession.collect.enable";
    public static final String ONLINE_NUM_ANY = "svc:login:onlineUserNum:any";
    public static final String ONLINE_NUM_WEB = "svc:login:onlineUserNum:web";
    public static final String ONLINE_NUM_MOBILE = "svc:login:onlineUserNum:mobile";
    private static final DistributeSessionlessCache CACHE = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("customRegion");

    public static void start() {
        Elector elector = ElectFactory.getElector((String)"OnlineSessionCollectElect");
        elector.registerListener(new ElectorListener(){

            public void notifyLostMaster() {
                OnlineSessionCollector.removeGauge(OnlineSessionCollector.TOTAL_NAME);
                OnlineSessionCollector.removeGauge(OnlineSessionCollector.WEB_NAME);
                OnlineSessionCollector.removeGauge(OnlineSessionCollector.MOBILE_NAME);
            }

            public void notifyMaster() {
                OnlineSessionCollector.registerOnlineMetrics();
            }
        });
        elector.start();
    }

    public static void registerOnlineMetrics() {
        MetricSystem.registerGauge((String)TOTAL_NAME, () -> OnlineSessionCollector.collect(ONLINE_NUM_ANY));
        MetricSystem.registerGauge((String)WEB_NAME, () -> OnlineSessionCollector.collect(ONLINE_NUM_WEB));
        MetricSystem.registerGauge((String)MOBILE_NAME, () -> OnlineSessionCollector.collect(ONLINE_NUM_MOBILE));
    }

    private static int collectFromDb(String onlineType) {
        String sql = "select fclient, count(*) as num from t_bas_session_history where flogouttime is null group by fclient";
        List accounts = AccountUtils.getAllAccountsOfCurrentEnv();
        HashMap countMap = new HashMap(3);
        for (Account account : accounts) {
            RequestContextInfo rc = new RequestContextInfo(account.getTenantId(), account.getAccountId());
            try {
                AutoCloseable ignored = rc.setupThreadRequestContext();
                Throwable throwable = null;
                try {
                    DB.query((DBRoute)DBRoute.of((String)"sys"), (String)sql, (Object[])new Object[0], rs -> {
                        while (rs.next()) {
                            String client = rs.getString("fclient");
                            int num = rs.getInt("num");
                            countMap.compute(client, (k, v) -> v == null ? num : v + num);
                            countMap.compute("total", (k, v) -> v == null ? num : v + num);
                        }
                        return null;
                    });
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (ignored == null) continue;
                    if (throwable != null) {
                        try {
                            ignored.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    ignored.close();
                }
            }
            catch (Exception e) {
                logger.info("Collect metrics of onlineSession count from DB. Error: ", (Object)e);
            }
        }
        return countMap.get(onlineType) == null ? 0 : (Integer)countMap.get(onlineType);
    }

    private static int collectFromCache(String onlineType) {
        List accounts = AccountUtils.getAllAccountsOfCurrentEnv();
        int count = 0;
        for (Account account : accounts) {
            String key = onlineType + "_" + account.getAccountId();
            Object val = CACHE.get(key);
            if (val == null || "null".equals(val)) continue;
            count += Integer.parseInt(String.valueOf(val));
        }
        return count;
    }

    private static int collect(String key) {
        if ("false".equals(System.getProperty(COLLECT_ENABLE, "true"))) {
            return 0;
        }
        long currentTime = System.currentTimeMillis();
        LastRecord last = recordMap.get(key);
        boolean needFromDb = last == null || currentTime - last.lastTimestamp >= LIMIT_INTERVAL_SECONDS * 1000L;
        int val = needFromDb ? OnlineSessionCollector.collectFromCache(key) : last.val;
        recordMap.put(key, new LastRecord(currentTime, val));
        return val;
    }

    private static void removeGauge(String name) {
        LastRecord record = recordMap.remove(name);
        if (record != null && MetricSystem.remove((String)name)) {
            logger.info("OnlineSessionCollectElect notifyLostMaster:The metrics name {} has been remove.", (Object)name);
        }
    }

    private static class LastRecord {
        private long lastTimestamp;
        private int val;

        public LastRecord(long lastTimestamp, int val) {
            this.lastTimestamp = lastTimestamp;
            this.val = val;
        }

        public int getVal() {
            return this.val;
        }

        public void setVal(int val) {
            this.val = val;
        }

        public long getLastTimestamp() {
            return this.lastTimestamp;
        }

        public void setLastTimestamp(long lastTimestamp) {
            this.lastTimestamp = lastTimestamp;
        }
    }
}

