/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.dashboard.metrics.query.sessions;

import java.util.List;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.dc.api.model.Account;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.eye.api.dashboard.metrics.base.TextChartData;
import kd.bos.eye.api.dashboard.metrics.entity.MetricsCondition;
import kd.bos.eye.api.dashboard.metrics.impl.IMetricsEsDaoImpl;
import kd.bos.eye.spi.BaseQueryParameter;
import kd.bos.eye.spi.IMetricsData;
import kd.bos.eye.util.StringFormatUtils;
import kd.bos.mservice.monitor.lang.LangRes;

public class OnlineSessionMetricsHandler
implements IMetricsData {
    public static final String ONLINE_NUM_ANY = "svc:login:onlineUserNum:any";
    public static final String ONLINE_NUM_WEB = "svc:login:onlineUserNum:web";
    public static final String ONLINE_NUM_MOBILE = "svc:login:onlineUserNum:mobile";
    private static final String ONLINE_TEMPLATE = "<table style='width:100%;text-align: center;font-size:18px'><tr><th style='text-align: center'>@%0%</th><th style='text-align: center'>WEB</th><th style='text-align: center'>Mobile</th></tr><tr style='font-size:fontSizeValue'><td style='color:green;font-weight:bold'>totalCount</td><td style='color:green;font-weight:bold'>webCount</td><td style='color:green;font-weight:bold'>mobileCount</td></tr></table>";
    private static final String ONLINE_METRICS_PRE = "kd.metrics.onlineSession.";
    private static final DistributeSessionlessCache CACHE = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("customRegion");

    private static String getOnlineTemplate() {
        return StringFormatUtils.format(ONLINE_TEMPLATE, LangRes.get((String)"OnlineSessionMetricsHandler_0", (String)"Total", (Object[])new Object[0]));
    }

    @Override
    public TextChartData query(BaseQueryParameter parameter) {
        TextChartData textChartData = new TextChartData();
        IMetricsEsDaoImpl esDao = new IMetricsEsDaoImpl();
        MetricsCondition condition = new MetricsCondition();
        condition.setRealDelayTime(60);
        List accounts = AccountUtils.getAllAccountsOfCurrentEnv();
        int totalSession = 0;
        int webSession = 0;
        int mobileSession = 0;
        for (Account account : accounts) {
            Object mobile;
            Object web = CACHE.get("svc:login:onlineUserNum:web_" + account.getAccountId());
            if (web != null && !"null".equals(web)) {
                webSession += Integer.parseInt(String.valueOf(web));
            }
            if ((mobile = CACHE.get("svc:login:onlineUserNum:mobile_" + account.getAccountId())) == null || "null".equals(mobile)) continue;
            mobileSession += Integer.parseInt(String.valueOf(mobile));
        }
        totalSession = webSession + mobileSession;
        String fontSize = "25px";
        String dataText = OnlineSessionMetricsHandler.getOnlineTemplate().replaceAll("totalCount", String.valueOf(totalSession)).replaceAll("webCount", String.valueOf(webSession)).replaceAll("mobileCount", String.valueOf(mobileSession)).replaceAll("fontSizeValue", fontSize);
        textChartData.setText(dataText);
        textChartData.setUnit("");
        return textChartData;
    }
}

