/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.dashboard.widgets;

import com.sun.net.httpserver.HttpExchange;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import kd.bos.eye.api.dashboard.AbstractDashboardHandler;
import kd.bos.eye.api.dashboard.lang.DashboardLangResBundle;
import kd.bos.eye.api.dashboard.vo.BaseParam;
import kd.bos.eye.api.dashboard.vo.Widgets;
import kd.bos.eye.api.oplog.OpLogManager;
import kd.bos.eye.api.oplog.OpLogger;
import kd.bos.eye.util.ApiResponse;
import kd.bos.eye.util.ExchangeVueUtils;
import kd.bos.government.metadata.MetadataFactory;
import kd.bos.government.metadata.Request;
import kd.bos.government.metadata.Result;
import kd.bos.government.metadata.db.DBRequest;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.JSONUtils;
import kd.bos.util.StringUtils;

public class QueryWidgetsHandler
extends AbstractDashboardHandler {
    private static final Log log = LogFactory.getLog(QueryWidgetsHandler.class);
    private static final OpLogger OPLOGGER = OpLogManager.getLogger();

    @Override
    protected void handle1(HttpExchange exchange) throws IOException {
        ApiResponse<List<Widgets>> response = new ApiResponse<List<Widgets>>();
        try {
            BaseParam param = ExchangeVueUtils.parseJsonFromPost(exchange, BaseParam.class);
            String id = "";
            String keyword = "";
            if (param != null) {
                id = param.getId();
                keyword = param.getKeyword();
            }
            List<Widgets> retList = this.getWidgets(id, keyword, this.isFromCosmiceye(exchange));
            if (DashboardLangResBundle.isNeedTranslate()) {
                for (Widgets widget : retList) {
                    widget.setTitle(DashboardLangResBundle.translateAll(widget.getTitle()));
                    widget.setParams(DashboardLangResBundle.translateAll(widget.getParams()));
                }
            }
            response.setCode(0);
            response.setData(retList);
            response.setMsg("success");
        }
        catch (Exception e) {
            log.error("Query widgets error\uff1a", (Throwable)e);
            response.setCode(-1);
            response.setMsg(e.getMessage());
        }
        this.writeJson(JSONUtils.toString(response), exchange);
    }

    private List<Widgets> getWidgets(String id, String keyword, boolean isFromCosmiceye) {
        if (isFromCosmiceye) {
            return this.getCosmiceyeWidgets(id, keyword);
        }
        DBRequest dbRequest = new DBRequest();
        String querySql = "select fid,ftitle,ftips,fmetrics,fparams,fused,fchartname,fcharttype,fcreated,fupdated from t_monitor_widgets";
        if (StringUtils.isNotEmpty((String)id)) {
            querySql = querySql + " where fid=" + id;
        } else if (StringUtils.isNotEmpty((String)keyword)) {
            querySql = querySql + " where ftitle like '%" + keyword + "%'";
        }
        dbRequest.setQueryRequest(new DBRequest.QueryRequest(querySql, new ArrayList()));
        List result = MetadataFactory.getStatement().executeQuery((Request)dbRequest);
        ArrayList<Widgets> retList = new ArrayList<Widgets>(result.size());
        for (Result row : result) {
            Widgets widgets = new Widgets();
            widgets.setId(row.getString("fid"));
            widgets.setTitle(row.getString("ftitle"));
            widgets.setTips(row.getString("ftips"));
            widgets.setMetrics(row.getString("fmetrics"));
            widgets.setParams(row.getString("fparams"));
            boolean used = "1".equals(row.getString("fused"));
            widgets.setUsed(used);
            widgets.setChartName(row.getString("fchartname"));
            widgets.setChartType(row.getString("fcharttype"));
            widgets.setCreated(row.getString("fcreated"));
            widgets.setUpdated(row.getString("fupdated"));
            retList.add(widgets);
        }
        return retList;
    }

    private List<Widgets> getCosmiceyeWidgets(String id, String keyword) {
        DBRequest dbRequest = new DBRequest();
        String querySql = "select fid,ftitle,fmetrics,fused,fchartname,fcharttype,fvaluetype,fcreated,fupdated from t_monitor_cosmiceye_widgets";
        if (StringUtils.isNotEmpty((String)id)) {
            querySql = querySql + " where fid=" + id;
        } else if (StringUtils.isNotEmpty((String)keyword)) {
            querySql = querySql + " where ftitle like '%" + keyword + "%'";
        }
        dbRequest.setQueryRequest(new DBRequest.QueryRequest(querySql, new ArrayList()));
        List result = MetadataFactory.getStatement().executeQuery((Request)dbRequest);
        ArrayList<Widgets> retList = new ArrayList<Widgets>(result.size());
        for (Result row : result) {
            Widgets widgets = new Widgets();
            widgets.setId(row.getString("fid"));
            widgets.setTitle(row.getString("ftitle"));
            widgets.setMetrics(row.getString("fmetrics"));
            boolean used = "1".equals(row.getString("fused"));
            widgets.setUsed(used);
            widgets.setChartName(row.getString("fchartname"));
            widgets.setChartType(row.getString("fcharttype"));
            widgets.setValueType(row.getString("fvaluetype"));
            widgets.setCreated(row.getString("fcreated"));
            widgets.setUpdated(row.getString("fupdated"));
            retList.add(widgets);
        }
        return retList;
    }
}

