/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.dashboard.widgets;

import com.sun.net.httpserver.HttpExchange;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.db.DB;
import kd.bos.eye.api.dashboard.AbstractDashboardHandler;
import kd.bos.eye.api.dashboard.vo.Widgets;
import kd.bos.eye.api.oplog.OpLogManager;
import kd.bos.eye.api.oplog.OpLogger;
import kd.bos.eye.api.oplog.OpType;
import kd.bos.eye.util.ApiResponse;
import kd.bos.eye.util.ExchangeVueUtils;
import kd.bos.government.metadata.MetadataFactory;
import kd.bos.government.metadata.Request;
import kd.bos.government.metadata.db.DBRequest;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.monitor.lang.LangRes;
import kd.bos.util.JSONUtils;
import kd.bos.util.StringUtils;

public class SaveWidgetsHandler
extends AbstractDashboardHandler {
    private static final Log log = LogFactory.getLog(SaveWidgetsHandler.class);
    private static final OpLogger OPLOGGER = OpLogManager.getLogger();

    @Override
    protected void handle1(HttpExchange exchange) throws IOException {
        ApiResponse<HashMap<String, String>> response = new ApiResponse<HashMap<String, String>>();
        try {
            Widgets body = ExchangeVueUtils.parseJsonFromPost(exchange, Widgets.class);
            HashMap<String, String> ret = new HashMap<String, String>();
            body.setTitle(this.cleanXss(body.getTitle()));
            body.setTips(this.cleanXss(body.getTips()));
            ret.put("isDuplicateWidget", "false");
            response.setData(ret);
            this.saveWidgets(body, ret, this.isFromCosmiceye(exchange));
            response.setCode(0);
            response.setMsg("success");
            OPLOGGER.opLog(exchange, OpType.ADD, LangRes.get((String)"WidgetsHandler_1", (String)"\u5fae\u4ef6\u5217\u8868", (Object[])new Object[0]), LangRes.get((String)"WidgetsHandler_5", (String)"\u65b0\u589e\u5fae\u4ef6\u5217\u8868", (Object[])new Object[0]));
        }
        catch (Exception e) {
            log.error("Save widget error:", (Throwable)e);
            response.setCode(-1);
            response.setMsg("Exception:" + e.getMessage());
        }
        this.writeJson(JSONUtils.toString(response), exchange);
    }

    private void saveWidgets(Widgets widget, Map<String, String> ret, boolean isFromCosmiceye) {
        if (isFromCosmiceye) {
            this.saveCosmiceyeWidgets(widget, ret);
            return;
        }
        if (StringUtils.isNotEmpty((String)widget.getId())) {
            this.updateWidgets(widget);
            return;
        }
        if (this.isDuplicateWidgets(widget, false)) {
            ret.put("isDuplicateWidget", "true");
            return;
        }
        widget.setId(DB.genStringId((String)"t_monitor_widgets"));
        ArrayList<Object> paramList = new ArrayList<Object>(8);
        paramList.add(widget.getId());
        paramList.add(widget.getTitle());
        paramList.add(widget.getTips());
        paramList.add(widget.getMetrics());
        paramList.add(widget.getParams());
        paramList.add(widget.isUsed());
        paramList.add(widget.getChartName());
        paramList.add(widget.getChartType());
        String sql = "insert into t_monitor_widgets values(?,?,?,?,?,?,?,?,now(),now())";
        DBRequest dbRequest = new DBRequest();
        dbRequest.setInsertRequest(new DBRequest.InsertRequest(sql, paramList));
        MetadataFactory.getStatement().executeInsert((Request)dbRequest);
    }

    private void updateWidgets(Widgets widget) {
        ArrayList<Object> paramList = new ArrayList<Object>(8);
        paramList.add(widget.getTitle());
        paramList.add(widget.getTips());
        paramList.add(widget.getMetrics());
        paramList.add(widget.getParams());
        paramList.add(widget.isUsed());
        paramList.add(widget.getChartName());
        paramList.add(widget.getChartType());
        paramList.add(widget.getId());
        String updateSql = "update t_monitor_widgets set ftitle=?, ftips=?, fmetrics=?, fparams=?, fused=?, fchartname=?, fcharttype=?, fupdated=now() where fid=?";
        DBRequest dbRequest = new DBRequest();
        dbRequest.setUpdateRequest(new DBRequest.UpdateRequest(updateSql, paramList));
        MetadataFactory.getStatement().executeUpdate((Request)dbRequest);
    }

    private void saveCosmiceyeWidgets(Widgets widget, Map<String, String> ret) {
        if (StringUtils.isNotEmpty((String)widget.getId())) {
            this.updateCosmiceyeWidgets(widget);
            return;
        }
        if (this.isDuplicateWidgets(widget, true)) {
            ret.put("isDuplicateWidget", "true");
            return;
        }
        widget.setId(DB.genStringId((String)"t_monitor_cosmiceye_widgets"));
        ArrayList<Object> paramList = new ArrayList<Object>(8);
        paramList.add(widget.getId());
        paramList.add(widget.getTitle());
        paramList.add(widget.getMetrics());
        paramList.add(widget.isUsed());
        paramList.add(widget.getChartName());
        paramList.add(widget.getChartType());
        paramList.add(widget.getValueType());
        String sql = "insert into t_monitor_cosmiceye_widgets values(?,?,?,?,?,?,?,now(),now())";
        DBRequest dbRequest = new DBRequest();
        dbRequest.setInsertRequest(new DBRequest.InsertRequest(sql, paramList));
        MetadataFactory.getStatement().executeInsert((Request)dbRequest);
    }

    private void updateCosmiceyeWidgets(Widgets widget) {
        ArrayList<Object> paramList = new ArrayList<Object>(8);
        paramList.add(widget.getTitle());
        paramList.add(widget.getMetrics());
        paramList.add(widget.isUsed());
        paramList.add(widget.getChartName());
        paramList.add(widget.getChartType());
        paramList.add(widget.getValueType());
        paramList.add(widget.getId());
        String updateSql = "update t_monitor_cosmiceye_widgets set ftitle=?, fmetrics=?, fused=?, fchartname=?, fcharttype=?, fvaluetype=?, fupdated=now() where fid=?";
        DBRequest dbRequest = new DBRequest();
        dbRequest.setUpdateRequest(new DBRequest.UpdateRequest(updateSql, paramList));
        MetadataFactory.getStatement().executeUpdate((Request)dbRequest);
    }

    public boolean isDuplicateWidgets(Widgets widgets, boolean isFromCosmiceye) {
        String tableName = isFromCosmiceye ? "t_monitor_cosmiceye_widgets" : "t_monitor_widgets";
        DBRequest dbRequest = new DBRequest();
        ArrayList<String> paramList = new ArrayList<String>(1);
        paramList.add(widgets.getTitle());
        String sql = String.format("select ftitle from %s where ftitle=?", tableName);
        dbRequest.setQueryRequest(new DBRequest.QueryRequest(sql, paramList));
        List result = MetadataFactory.getStatement().executeQuery((Request)dbRequest);
        return result.size() > 0;
    }

    private String cleanXss(String message) {
        if (!StringUtils.isEmpty((String)message)) {
            message = message.replaceAll("'", "&#39;");
            message = message.replaceAll("<", "&lt;");
            message = message.replaceAll(">", "&gt;");
            message = message.replaceAll("\"", "&quot;");
            message = message.replaceAll("'", "&#x27;");
            message = message.replaceAll("/", "&#x2f;");
        }
        return message;
    }
}

