/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.dbmonitor.commons;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import kd.bos.eye.api.dbmonitor.commons.MonitorDB;

public interface JDBCConnectionHelper {
    public static final String DEFAULT_CONNECTION_TIMEOUT = "2000";
    public static final String MYSQL_URL_PREFIX = "jdbc:mysql://";
    public static final String PG_URL_PREFIX = "jdbc:postgresql://";
    public static final String ORACLE_URL_PREFIX = "jdbc:oracle:thin:@";
    public static final String MYSQL_DEFAULT_DATABASE = "information_schema";
    public static final String PG_DEFAULT_DATABASE = "postgres";
    public static final String ORACLE_DEFAULT_DATABASE = "orcl";

    default public Connection getConnection(String url, MonitorDB db) throws ClassNotFoundException, SQLException {
        Properties prop = new Properties();
        prop.setProperty("driverClassName", db.getJdbcDriver());
        prop.setProperty("url", url);
        prop.setProperty("user", db.getAccount());
        prop.setProperty("password", db.getPsd());
        prop.setProperty("connectTimeout", DEFAULT_CONNECTION_TIMEOUT);
        prop.setProperty("socketTimeout", DEFAULT_CONNECTION_TIMEOUT);
        prop.setProperty("initialTimeout", DEFAULT_CONNECTION_TIMEOUT);
        Class.forName(db.getJdbcDriver());
        return DriverManager.getConnection(url, prop);
    }
}

