/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.dbmonitor.handler;

import com.sun.net.httpserver.HttpExchange;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import kd.bos.encrypt.Encrypters;
import kd.bos.eye.api.dbmonitor.ProcessListExecutorFactory;
import kd.bos.eye.api.dbmonitor.commons.MonitorDB;
import kd.bos.eye.api.dbmonitor.commons.MonitorDBDao;
import kd.bos.eye.api.dbmonitor.commons.Utils;
import kd.bos.eye.api.dbmonitor.entity.req.MonitorDBReq;
import kd.bos.eye.api.dbmonitor.entity.vo.ProcessExecParam;
import kd.bos.eye.api.dbmonitor.service.ProcessListExecutor;
import kd.bos.eye.api.log.KDException;
import kd.bos.eye.api.oplog.OpLogManager;
import kd.bos.eye.api.oplog.OpLogger;
import kd.bos.eye.api.oplog.OpType;
import kd.bos.eye.httpserver.AbstractHttpHandler;
import kd.bos.eye.util.ApiResponse;
import kd.bos.eye.util.ExchangeVueUtils;
import kd.bos.eye.util.MonitorLoginUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.monitor.lang.LangRes;
import kd.bos.util.JSONUtils;

public class DataBaseManageHandler
extends AbstractHttpHandler {
    private static final Log log = LogFactory.getLog(DataBaseManageHandler.class);
    private static final OpLogger OPLOGGER = OpLogManager.getLogger();
    private static final String DATA_MSG_NOT_IN_CLUSTER = "unCluster";
    private static final String CODE = "code";
    private static final String MSG = "msg";
    private static final String SUCCESS = "success";
    private static final String FAILURE = "failure";

    @Override
    protected void handle0(HttpExchange exchange) throws IOException {
        MonitorDBReq req = ExchangeVueUtils.parseJsonFromPost(exchange, MonitorDBReq.class);
        ApiResponse response = new ApiResponse();
        HashMap<String, Object> result = new HashMap<String, Object>();
        MonitorDBDao dao = new MonitorDBDao();
        try {
            if (req.getOperation().equals("query")) {
                List<MonitorDB> dbs = dao.getDBList();
                dbs.forEach(this::checkDB);
                result.put("sqlSnapshotSupportDB", Utils.getSupportDbTypes());
                result.put("dbList", dbs);
                result.put(CODE, SUCCESS);
            } else if (req.getOperation().equals("edit")) {
                String msg = this.check(req, true);
                if (msg.equals("OK")) {
                    dao.saveAndUpdateMonitorDB(req);
                    result.put(CODE, SUCCESS);
                } else {
                    result.put(CODE, FAILURE);
                }
                result.put(MSG, msg);
                OPLOGGER.opLog(exchange, OpType.EDIT, LangRes.get((String)"DataBaseManageHandler_1", (String)"\u76d1\u63a7\u5e93\u914d\u7f6e", (Object[])new Object[0]), LangRes.get((String)"DataBaseManageHandler_3", (String)"\u4fee\u6539\u76d1\u63a7\u5e93\u914d\u7f6e\u4fe1\u606f\uff0c\u4fee\u6539\u6570\u636e\u5e93\u7c7b\u578b\u4e3a\uff1a", (Object[])new Object[0]) + req.getType());
            } else if (req.getOperation().equals("testSqlSnapshot")) {
                String msg = this.check(req, true);
                result.put(CODE, msg.equals("OK") ? SUCCESS : FAILURE);
                result.put(MSG, msg);
                OPLOGGER.opLog(exchange, OpType.EXECUTE, LangRes.get((String)"DataBaseManageHandler_1", (String)"\u76d1\u63a7\u5e93\u914d\u7f6e", (Object[])new Object[0]), LangRes.get((String)"DataBaseManageHandler_4", (String)"\u6267\u884c\u6d4b\u8bd5\u8fde\u63a5\u64cd\u4f5c\uff0c\u6d4b\u8bd5\u6570\u636e\u5e93\u7c7b\u578b\u4e3a\uff1a", (Object[])new Object[0]) + req.getType());
            }
        }
        catch (Exception e) {
            log.error("\u76d1\u63a7\u5e93\u64cd\u4f5c\u5931\u8d25:{}", (Object)e.getMessage(), (Object)e);
            result.put(CODE, FAILURE);
            result.put(MSG, e.getMessage());
        }
        response.setData(result);
        this.writeJson(JSONUtils.toString(response), exchange);
    }

    private void checkDB(MonitorDB db) {
        MonitorDBReq monitorDB = new MonitorDBReq(db.getType(), db.getAddress(), db.getAccount(), db.getPsd(), db.getJdbcDriver(), db.getSysDBName());
        String msg = this.check(monitorDB, false);
        db.setDes(msg);
        db.setPsd("");
    }

    private String check(MonitorDB paramInfo, boolean isFromFront) {
        MonitorDB db = Utils.getMonitorIDBInfo(paramInfo.getAddress());
        if (db != null) {
            ProcessListExecutor executor = ProcessListExecutorFactory.getInstance().create(paramInfo.getType());
            ProcessExecParam param = new ProcessExecParam();
            if (isFromFront) {
                param.setPsd(MonitorLoginUtils.getDecryptPassword("DBConfig", paramInfo.getPsd()));
            } else {
                param.setPsd(Encrypters.decode((String)paramInfo.getPsd()));
            }
            param.setType(paramInfo.getType());
            param.setAccount(paramInfo.getAccount());
            param.setJdbcDriver(db.getJdbcDriver());
            param.setSysDBName(db.getSysDBName());
            param.setAddress(paramInfo.getAddress());
            param.setLimit(1);
            param.setFilterTime(100L);
            try {
                executor.querySQLSnapshot(param);
                return "OK";
            }
            catch (KDException e) {
                if (e.getMessage().contains("Access denied")) {
                    return "Access denied";
                }
                if (e.getMessage().contains("communications link failure")) {
                    return "link failure";
                }
                if (e.getMessage().contains("No Permission")) {
                    return "No Permission";
                }
                return e.getMessage();
            }
        }
        return DATA_MSG_NOT_IN_CLUSTER;
    }
}

