/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.dbmonitor.handler;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.sun.net.httpserver.HttpExchange;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.eye.api.dbmonitor.ProcessListExecutorFactory;
import kd.bos.eye.api.dbmonitor.commons.MonitorDB;
import kd.bos.eye.api.dbmonitor.commons.MonitorDBDao;
import kd.bos.eye.api.dbmonitor.entity.vo.ProcessExecParam;
import kd.bos.eye.api.dbmonitor.entity.vo.ProcessInfoVo;
import kd.bos.eye.api.dbmonitor.service.ProcessListExecutor;
import kd.bos.eye.api.log.KDException;
import kd.bos.eye.api.oplog.OpLogManager;
import kd.bos.eye.api.oplog.OpLogger;
import kd.bos.eye.httpserver.AbstractHttpHandler;
import kd.bos.eye.util.ApiResponse;
import kd.bos.eye.util.ExchangeVueUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.JSONUtils;

public class ProcessListHandler
extends AbstractHttpHandler {
    private static final Log log = LogFactory.getLog(ProcessListHandler.class);
    private static final OpLogger OPLOGGER = OpLogManager.getLogger();

    @Override
    protected void handle0(HttpExchange exchange) throws IOException {
        ArrayList<ProcessInfoVo> processInfoList = new ArrayList<ProcessInfoVo>(10);
        Map<String, String> params = ExchangeVueUtils.parseParameters(exchange);
        String dbsInfo = params.get("db");
        String time = params.get("time");
        String limit = params.get("limit");
        if (dbsInfo == null || dbsInfo.equals("")) {
            throw new KDException("params: db cannot be empty");
        }
        String[] dbs = dbsInfo.split("\\|");
        List<String> addressList = Arrays.stream(dbs).map(s -> s.split("@")[1]).collect(Collectors.toList());
        List<MonitorDB> monitorDBList = new MonitorDBDao().getMonitorDBList(addressList);
        for (MonitorDB dbInfo : monitorDBList) {
            ProcessListExecutor executor = ProcessListExecutorFactory.getInstance().create(dbInfo.getType());
            ProcessExecParam param = new ProcessExecParam();
            param.setType(dbInfo.getType());
            param.setAddress(dbInfo.getAddress());
            param.setSysDBName(dbInfo.getSysDBName());
            param.setAccount(dbInfo.getAccount());
            param.setPsd(dbInfo.getPsd());
            param.setFilterTime(Long.parseLong(time));
            param.setLimit(Integer.parseInt(limit));
            param.setJdbcDriver(dbInfo.getJdbcDriver());
            List<Object> voList = new ArrayList(10);
            try {
                voList = executor.querySQLSnapshot(param);
            }
            catch (Exception e) {
                log.error("Monitor db query processlist error:{}", (Object)e.getMessage(), (Object)e);
            }
            processInfoList.addAll(voList);
        }
        JSONArray array = this.covertProcessListToArray(processInfoList);
        ApiResponse<JSONArray> response = new ApiResponse<JSONArray>();
        response.setCode(0);
        response.setMsg("success");
        response.setData(array);
        this.writeJson(JSONUtils.toString(response), exchange);
    }

    private JSONArray covertProcessListToArray(List<ProcessInfoVo> list) {
        list.sort(new Comparator<ProcessInfoVo>(){

            @Override
            public int compare(ProcessInfoVo o1, ProcessInfoVo o2) {
                return Integer.parseInt(o2.getResult().get(9).getValue().toString()) - Integer.parseInt(o1.getResult().get(9).getValue().toString());
            }
        });
        JSONArray array = new JSONArray();
        for (ProcessInfoVo vo : list) {
            JSONObject obj = new JSONObject();
            List<ProcessInfoVo.ActivityStat> activityStats = vo.getResult();
            for (ProcessInfoVo.ActivityStat field : activityStats) {
                JSONObject objNode = new JSONObject();
                objNode.put("rawName", (Object)field.getColumn());
                objNode.put("value", field.getValue());
                obj.put(field.getAlias(), (Object)objNode);
            }
            array.add((Object)obj);
        }
        return array;
    }
}

