/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.dbmonitor.handler;

import com.alibaba.fastjson.JSONObject;
import com.sun.net.httpserver.HttpExchange;
import java.io.IOException;
import java.util.Map;
import kd.bos.eye.api.dbmonitor.SqlKillerFactory;
import kd.bos.eye.api.dbmonitor.commons.MonitorDB;
import kd.bos.eye.api.dbmonitor.commons.MonitorDBDao;
import kd.bos.eye.api.dbmonitor.entity.vo.KillSqlParam;
import kd.bos.eye.api.dbmonitor.service.SqlKiller;
import kd.bos.eye.httpserver.AbstractHttpHandler;
import kd.bos.eye.util.ApiResponse;
import kd.bos.eye.util.ExchangeVueUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.JSONUtils;

public class SqlKillHandler
extends AbstractHttpHandler {
    private static Log log = LogFactory.getLog(SqlKillHandler.class);

    @Override
    protected void handle0(HttpExchange exchange) throws IOException {
        ApiResponse response = new ApiResponse();
        try {
            Map<String, String> params = ExchangeVueUtils.parsePostParameters(exchange);
            JSONObject obj = JSONObject.parseObject((String)params.keySet().toArray()[0].toString());
            String id = obj.get((Object)"id").toString();
            String serial = obj.get((Object)"serial").toString();
            String dbType = obj.get((Object)"dbType").toString();
            String dbAddress = obj.get((Object)"address").toString();
            MonitorDBDao monitorDBDao = new MonitorDBDao();
            MonitorDB dbInfo = monitorDBDao.getMonitorDB(dbAddress);
            if (dbInfo != null) {
                MonitorDB monitorDBInfo = new MonitorDBDao().getMonitorDB(dbAddress);
                if (monitorDBInfo != null) {
                    SqlKiller executor = SqlKillerFactory.getInstance().create(dbType);
                    KillSqlParam param = new KillSqlParam();
                    param.setAccount(monitorDBInfo.getAccount());
                    param.setSysDBName(monitorDBInfo.getSysDBName());
                    param.setId(id);
                    param.setPid(id);
                    param.setSid(id);
                    param.setSerial_(serial);
                    param.setType(monitorDBInfo.getType());
                    param.setAddress(monitorDBInfo.getAddress());
                    param.setJdbcDriver(monitorDBInfo.getJdbcDriver());
                    param.setPsd(monitorDBInfo.getPsd());
                    executor.kill(param);
                }
                response.setMsg("success");
            } else {
                response.setMsg(String.format("get db instance failed: %s", dbAddress));
            }
        }
        catch (Exception e) {
            if (e.getMessage().contains("pg_signal_backend")) {
                response.setMsg("pg_signal_backend");
            }
            response.setMsg("error");
            log.error("kill sql:{}", (Object)e.getMessage());
        }
        response.setCode(0);
        this.writeJson(JSONUtils.toString(response), exchange);
    }
}

