/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.dbmonitor.service.impl;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import kd.bos.eye.api.dbmonitor.commons.JDBCConnectionHelper;
import kd.bos.eye.api.dbmonitor.entity.vo.ProcessExecParam;
import kd.bos.eye.api.dbmonitor.entity.vo.ProcessInfoVo;
import kd.bos.eye.api.dbmonitor.service.ProcessListExecutor;
import kd.bos.eye.api.log.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;

public class MySQLProcessListExecutor
implements ProcessListExecutor,
JDBCConnectionHelper {
    private static final Log log = LogFactory.getLog(MySQLProcessListExecutor.class);

    @Override
    public List<ProcessInfoVo> querySQLSnapshot(ProcessExecParam db) {
        ArrayList<ProcessInfoVo> ret = new ArrayList<ProcessInfoVo>();
        String database = StringUtils.isEmpty((String)db.getSysDBName()) ? "information_schema" : db.getSysDBName();
        try (Connection conn = this.getConnection("jdbc:mysql://" + db.getAddress() + "/" + database, db);
             PreparedStatement statement = conn.prepareStatement(this.buildSql(db));
             ResultSet resultSet = statement.executeQuery();){
            while (resultSet.next()) {
                String sql = resultSet.getString("info");
                if (!this.sqlFilter(sql)) continue;
                ret.add(this.convertValue(resultSet, db));
            }
        }
        catch (ClassNotFoundException | SQLException e) {
            log.error("MySQL query SQL snapshot error: ", (Throwable)e);
            throw new KDException(e.getMessage());
        }
        return ret;
    }

    private String buildSql(ProcessExecParam db) {
        float time = BigDecimal.valueOf(db.getFilterTime()).divide(BigDecimal.valueOf(1000L), 3, RoundingMode.DOWN).floatValue();
        return "SELECT id, user, host, db, command, time, state, left(info,5000) info from information_schema.processlist where db <> 'information_schema' and command not in ('Sleep','Daemon','Binlog Dump GTID') and time >= " + time + " order by time desc limit " + db.getLimit();
    }

    private ProcessInfoVo convertValue(ResultSet resultSet, ProcessExecParam db) throws SQLException {
        ArrayList<ProcessInfoVo.ActivityStat> result = new ArrayList<ProcessInfoVo.ActivityStat>();
        ProcessInfoVo vo = new ProcessInfoVo();
        result.add(new ProcessInfoVo.ActivityStat("dbType", "dbType", "MySQL"));
        result.add(new ProcessInfoVo.ActivityStat("dbAddress", "dbAddress", db.getAddress()));
        result.add(new ProcessInfoVo.ActivityStat("id", "id", resultSet.getInt("id")));
        result.add(new ProcessInfoVo.ActivityStat("info", "sql", resultSet.getString("info")));
        result.add(new ProcessInfoVo.ActivityStat("traceId", "traceId", this.parseTraceId(resultSet.getString("info"))));
        result.add(new ProcessInfoVo.ActivityStat("db", "schema", resultSet.getString("db")));
        result.add(new ProcessInfoVo.ActivityStat("host", "client", resultSet.getString("host")));
        result.add(new ProcessInfoVo.ActivityStat("user", "user", resultSet.getString("user")));
        result.add(new ProcessInfoVo.ActivityStat("state", "status", resultSet.getString("state")));
        result.add(new ProcessInfoVo.ActivityStat("time", "useTime", resultSet.getInt("time") * 1000));
        vo.setResult(result);
        return vo;
    }
}

