/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.dbmonitor.service.impl;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.List;
import kd.bos.eye.api.dbmonitor.commons.JDBCConnectionHelper;
import kd.bos.eye.api.dbmonitor.entity.vo.ProcessExecParam;
import kd.bos.eye.api.dbmonitor.entity.vo.ProcessInfoVo;
import kd.bos.eye.api.dbmonitor.service.ProcessListExecutor;
import kd.bos.eye.api.log.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;

public class PGProcessListExecutor
implements ProcessListExecutor,
JDBCConnectionHelper {
    private static final Log log = LogFactory.getLog(PGProcessListExecutor.class);

    @Override
    public List<ProcessInfoVo> querySQLSnapshot(ProcessExecParam db) {
        String database = StringUtils.isEmpty((String)db.getSysDBName()) ? "postgres" : db.getSysDBName();
        ArrayList<ProcessInfoVo> ret = new ArrayList<ProcessInfoVo>(16);
        try (Connection conn = this.getConnection("jdbc:postgresql://" + db.getAddress() + "/" + database, db);
             PreparedStatement preparedStatement = conn.prepareStatement(this.buildSql(db));
             ResultSet resultSet = preparedStatement.executeQuery();){
            while (resultSet.next()) {
                String query = resultSet.getString("query");
                if (!this.sqlFilter(query)) continue;
                ret.add(this.convertValue(resultSet, db));
            }
        }
        catch (SQLException e) {
            log.error("PostgreSQL query SQL snapshot error: ", (Throwable)e);
            if (e.getMessage().contains("authentication failed")) {
                throw new KDException("Access denied");
            }
            if (e.getMessage().contains("refused") || e.getMessage().contains("\u5c1d\u8bd5\u8fde\u7ebf\u5df2\u5931\u8d25")) {
                throw new KDException("communications link failure");
            }
        }
        catch (ClassNotFoundException e) {
            log.error("PostgreSQL query SQL snapshot error: ", (Throwable)e);
            throw new KDException(e.getMessage());
        }
        return ret;
    }

    private String buildSql(ProcessExecParam db) {
        float time = BigDecimal.valueOf(db.getFilterTime()).divide(BigDecimal.valueOf(1000L), 3, RoundingMode.DOWN).floatValue();
        return "SELECT  pid, usename, client_addr, client_port, datname, now() - query_start as time, wait_event, state, query FROM pg_stat_activity WHERE state = 'active' and (now() - query_start) >= interval '" + time + " seconds' and query not like 'COMMIT%' and query not like 'SET%' and query not like 'SHOW%' and query not like 'ROLLBACK%' and query != '' limit " + db.getLimit();
    }

    private ProcessInfoVo convertValue(ResultSet resultSet, ProcessExecParam db) throws SQLException {
        ProcessInfoVo vo = new ProcessInfoVo();
        ArrayList<ProcessInfoVo.ActivityStat> result = new ArrayList<ProcessInfoVo.ActivityStat>();
        result.add(new ProcessInfoVo.ActivityStat("pid", "id", String.valueOf(resultSet.getInt("pid"))));
        result.add(new ProcessInfoVo.ActivityStat("dbType", "dbType", "PostgreSQL"));
        result.add(new ProcessInfoVo.ActivityStat("dbAddress", "dbAddress", db.getAddress()));
        result.add(new ProcessInfoVo.ActivityStat("query", "sql", resultSet.getString("query")));
        result.add(new ProcessInfoVo.ActivityStat("traceId", "traceId", this.parseTraceId(resultSet.getString("query"))));
        result.add(new ProcessInfoVo.ActivityStat("datname", "schema", resultSet.getString("datname")));
        result.add(new ProcessInfoVo.ActivityStat("client", "client", resultSet.getString("client_addr") + ":" + resultSet.getString("client_port")));
        result.add(new ProcessInfoVo.ActivityStat("usename", "user", resultSet.getString("usename")));
        result.add(new ProcessInfoVo.ActivityStat("wait_event", "status", resultSet.getString("wait_event")));
        result.add(new ProcessInfoVo.ActivityStat("time", "useTime", resultSet.getTimestamp("time").toLocalDateTime().toInstant(ZoneOffset.UTC).toEpochMilli()));
        vo.setResult(result);
        return vo;
    }
}

