/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.dlock;

import com.sun.net.httpserver.HttpExchange;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import kd.bos.context.RequestContext;
import kd.bos.dc.api.model.Account;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.dlock.AbstractDLock;
import kd.bos.dlock.DLock;
import kd.bos.dlock.DLockInfo;
import kd.bos.eye.api.dlock.DlockRequest;
import kd.bos.eye.api.oplog.OpLogManager;
import kd.bos.eye.api.oplog.OpLogger;
import kd.bos.eye.api.oplog.OpType;
import kd.bos.eye.config.EyeConfig;
import kd.bos.eye.httpserver.AbstractHttpHandler;
import kd.bos.eye.util.ExchangeVueUtils;
import kd.bos.mservice.monitor.lang.LangRes;
import kd.bos.util.JSONUtils;

public class DLockApiHandler
extends AbstractHttpHandler {
    private static final OpLogger OPLOGGER = OpLogManager.getLogger();
    private String context;

    public DLockApiHandler(String context) {
        this.context = context;
    }

    @Override
    protected void handle0(HttpExchange exchange) throws IOException {
        DlockRequest params = null;
        HashMap<String, Object> response = new HashMap<String, Object>(8);
        try {
            params = (DlockRequest)ExchangeVueUtils.parsePostJson(exchange, DlockRequest.class);
            String requestAccountId = params.getAccountId();
            String unLockPath = params.getUnLockPath();
            String clearPath = params.getClearPath();
            DLock dlock = DLock.create((String)"none");
            String[] accountIds = ((AbstractDLock)dlock).getLockAccountIds();
            String baseUrl = this.getInnerHandlerUrl();
            ArrayList tableList = new ArrayList(accountIds.length);
            int i = 0;
            for (String accountId : accountIds) {
                RequestContext.create().setAccountId(accountId);
                TreeMap map = new TreeMap(DLock.getAllLockInfo());
                int size = map.size();
                if (size <= 0) continue;
                try {
                    Account account = AccountUtils.getAccountById((String)accountId);
                    for (Map.Entry entry : map.entrySet()) {
                        ++i;
                        HashMap<String, Object> lockInfo = new HashMap<String, Object>(12);
                        String path = (String)entry.getKey();
                        if (requestAccountId.equals(accountId) && path.equals(unLockPath)) {
                            DLock.forceUnlock((String[])new String[]{path});
                        } else if (requestAccountId.equals(accountId) && path.equals(clearPath)) {
                            DLock.forceClear((String[])new String[]{path});
                        }
                        DLockInfo di = (DLockInfo)entry.getValue();
                        lockInfo.put("tenantId", account.getTenantId());
                        lockInfo.put("accountName", account.getAccountName());
                        lockInfo.put("accountNumber", account.getAccountNumber());
                        lockInfo.put("accountId", accountId);
                        lockInfo.put("unLockPath", path);
                        lockInfo.put("clearPath", path);
                        lockInfo.put("pttl", di.getPttl());
                        lockInfo.put("createTime", di.getCreateTime());
                        lockInfo.put("desc", di.getDesc());
                        lockInfo.put("instance", di.getInstance());
                        lockInfo.put("key", di.getKey());
                        lockInfo.put("owner", di.getOwner());
                        lockInfo.put("storePath", di.getStorePath());
                        lockInfo.put("waitingLocks", di.getWaitingLocks());
                        tableList.add(lockInfo);
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            response.put("url", baseUrl);
            String dlockType = System.getProperty("DLock.type", "zookeeper");
            response.put("dlockType", dlockType);
            if (!"redis".equals(dlockType)) {
                response.put("performance", System.getProperty("DLock.performance", "false"));
            }
            response.put("code", 0);
            response.put("data", tableList);
            response.put("count", i);
            this.addOpLog(exchange, unLockPath, clearPath);
        }
        catch (Exception e) {
            response.put("code", -1);
            response.put("msg", e.getMessage());
        }
        String str = JSONUtils.toString(response);
        this.writeJson(str, exchange);
    }

    private String getInnerHandlerUrl() {
        return EyeConfig.getNodeInfo().getMonitorUrl(false) + this.context;
    }

    private void addOpLog(HttpExchange exchange, String unLockPath, String clearPath) {
        if (unLockPath != null) {
            OPLOGGER.opLog(exchange, OpType.EXECUTE, LangRes.get((String)"DLockApiHandler_1", (String)"\u5206\u5e03\u5f0f\u9501", (Object[])new Object[0]), LangRes.get((String)"DLockApiHandler_2", (String)"\u89e3\u9501:", (Object[])new Object[0]) + unLockPath);
        } else if (clearPath != null) {
            OPLOGGER.opLog(exchange, OpType.EXECUTE, LangRes.get((String)"DLockApiHandler_1", (String)"\u5206\u5e03\u5f0f\u9501", (Object[])new Object[0]), LangRes.get((String)"DLockApiHandler_3", (String)"\u6e05\u7406\u9501:", (Object[])new Object[0]) + clearPath);
        }
    }
}

