/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.dtx;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;

public class ThreadPoolUtils {
    private static final Log logger = LogFactory.getLog(ThreadPoolUtils.class);
    private static final ThreadPool DTX_ACCOUNT_EXECUTOR = ThreadPools.newFixedThreadPool((String)"Monitor-DTX", (int)1);

    public static <T> T submit(Callable<T> callable) {
        Future future = DTX_ACCOUNT_EXECUTOR.submit(callable);
        while (!future.isDone()) {
        }
        try {
            return (T)future.get();
        }
        catch (InterruptedException | ExecutionException e) {
            logger.info("getting dtx scenes info in future. Error: ", (Object)e);
            return null;
        }
    }
}

