/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.dtx.dao.lockedBusiness;

import java.sql.Timestamp;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.RequestContextInfo;
import kd.bos.dc.api.model.Account;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.eye.api.dtx.ThreadPoolUtils;
import kd.bos.eye.api.dtx.entity.lockedBusiness.LockedBusinessInfo;
import kd.bos.eye.api.dtx.entity.lockedBusiness.LockedBusinessSearchParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.tenant.TenantInfo;
import kd.bos.util.StringUtils;

public class LockedBusinessDao {
    private static final Log logger = LogFactory.getLog(LockedBusinessDao.class);
    public static final DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");

    public List<LockedBusinessInfo> getLockedBusinessInfo(LockedBusinessSearchParam searchParam) {
        return ThreadPoolUtils.submit(() -> this.getLockedBusinessInfo0(searchParam));
    }

    public Boolean deleteLockedBusinessInfo(LockedBusinessSearchParam searchParam) {
        return ThreadPoolUtils.submit(() -> this.deleteLockedBusinessInfo0(searchParam));
    }

    private Boolean deleteLockedBusinessInfo0(LockedBusinessSearchParam searchParam) {
        try {
            if (searchParam != null && StringUtils.isNotEmpty((String)searchParam.getTenantId())) {
                TenantInfo tenantInfo = AccountUtils.getTenantByid((String)searchParam.getTenantId());
                this.deleteLockedBusinessInfoByTenant(tenantInfo, searchParam);
                return true;
            }
            List allTenants = AccountUtils.getAllTenantsByCurrentEnv();
            for (TenantInfo tenantInfo : allTenants) {
                this.deleteLockedBusinessInfoByTenant(tenantInfo, searchParam);
            }
            return true;
        }
        catch (Exception e) {
            logger.error("Delete locked business infos by tenant failed. Error: ", (Throwable)e);
            return false;
        }
    }

    private void deleteLockedBusinessInfoByTenant(TenantInfo tenantInfo, LockedBusinessSearchParam searchParam) throws Exception {
        List allAccounts = AccountUtils.getAllAccounts((String)tenantInfo.getId());
        for (Account account : allAccounts) {
            this.deleteLockedBusinessInfoByAccount(account, searchParam);
        }
    }

    private void deleteLockedBusinessInfoByAccount(Account account, LockedBusinessSearchParam searchParam) throws Exception {
        String sql = "delete from t_cbs_dtx_business where fid = ?";
        String[] fids = searchParam.getFids();
        ArrayList<Object[]> params = new ArrayList<Object[]>(10);
        for (String fid : fids) {
            long lid = Long.parseLong(fid);
            Object[] id = new Object[]{lid};
            params.add(id);
        }
        RequestContextInfo rc = new RequestContextInfo(account.getTenantId(), account.getAccountId());
        try (AutoCloseable ignored = rc.setupThreadRequestContext();){
            DB.executeBatch((DBRoute)DBRoute.of((String)"sys"), (String)sql, params);
        }
        catch (Exception e) {
            logger.error("Delete locked business infos by account failed. Error: ", (Throwable)e);
            throw e;
        }
    }

    private List<LockedBusinessInfo> getLockedBusinessInfo0(LockedBusinessSearchParam searchParam) {
        ArrayList<LockedBusinessInfo> lockedBusinessInfos = new ArrayList(10);
        int size = searchParam.getSize();
        HashMap<String, Integer> sizeMap = new HashMap<String, Integer>(16);
        sizeMap.put("size", size);
        if (StringUtils.isNotEmpty((String)searchParam.getTenantId())) {
            TenantInfo tenantInfo = AccountUtils.getTenantByid((String)searchParam.getTenantId());
            lockedBusinessInfos = this.getLockedBusinessInfoByTenant(tenantInfo, sizeMap);
            return lockedBusinessInfos;
        }
        List allTenants = AccountUtils.getAllTenantsByCurrentEnv();
        for (TenantInfo tenantInfo : allTenants) {
            lockedBusinessInfos.addAll(this.getLockedBusinessInfoByTenant(tenantInfo, sizeMap));
        }
        return lockedBusinessInfos;
    }

    private List<LockedBusinessInfo> getLockedBusinessInfoByTenant(TenantInfo tenantInfo, Map<String, Integer> sizeMap) {
        List allAccounts = AccountUtils.getAllAccounts((String)tenantInfo.getId());
        ArrayList<LockedBusinessInfo> lockedBusinessInfos = new ArrayList<LockedBusinessInfo>(10);
        for (Account account : allAccounts) {
            lockedBusinessInfos.addAll(this.getLockedBusinessInfoByAccount(account, sizeMap));
        }
        return lockedBusinessInfos;
    }

    private List<LockedBusinessInfo> getLockedBusinessInfoByAccount(Account account, Map<String, Integer> sizeMap) {
        ArrayList<LockedBusinessInfo> lockedBusinessInfos = new ArrayList<LockedBusinessInfo>(10);
        String sql = "select t.fid as id, t.fxid as xid, t.fbusiness_id as businessId, t.fbusiness_type as businessType, t.fcreate_time as createTime from t_cbs_dtx_business t order by t.fcreate_time";
        RequestContextInfo rc = new RequestContextInfo(account.getTenantId(), account.getAccountId());
        try (AutoCloseable ignored = rc.setupThreadRequestContext();){
            DB.query((DBRoute)DBRoute.of((String)"sys"), (String)sql, rs -> {
                while (rs.next()) {
                    String formatCreateTime;
                    Timestamp createTime;
                    LockedBusinessInfo lockedBusinessInfo;
                    if ((Integer)sizeMap.get("size") > 0) {
                        lockedBusinessInfo = new LockedBusinessInfo();
                        lockedBusinessInfo.setId(Long.toString(rs.getLong("id")));
                        lockedBusinessInfo.setXid(rs.getString("xid"));
                        lockedBusinessInfo.setBusinessId(rs.getString("businessId"));
                        lockedBusinessInfo.setBusinessType(rs.getString("businessType"));
                        createTime = rs.getTimestamp("createTime");
                        formatCreateTime = createTime.toLocalDateTime().format(dateTimeFormatter);
                        lockedBusinessInfo.setCreateTime(formatCreateTime);
                        lockedBusinessInfos.add(lockedBusinessInfo);
                        sizeMap.put("size", (Integer)sizeMap.get("size") - 1);
                    }
                    if ((Integer)sizeMap.get("size") != -1) continue;
                    lockedBusinessInfo = new LockedBusinessInfo();
                    lockedBusinessInfo.setId(Long.toString(rs.getLong("id")));
                    lockedBusinessInfo.setXid(rs.getString("xid"));
                    lockedBusinessInfo.setBusinessId(rs.getString("businessId"));
                    lockedBusinessInfo.setBusinessType(rs.getString("businessType"));
                    createTime = rs.getTimestamp("createTime");
                    formatCreateTime = createTime.toLocalDateTime().format(dateTimeFormatter);
                    lockedBusinessInfo.setCreateTime(formatCreateTime);
                    lockedBusinessInfos.add(lockedBusinessInfo);
                }
                return null;
            });
        }
        catch (Exception e) {
            logger.error("Getting locked business infos by account. Error: ", (Throwable)e);
            return Collections.emptyList();
        }
        return lockedBusinessInfos;
    }
}

