/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.dtx.dao.methodparams;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.RequestContextInfo;
import kd.bos.dc.api.model.Account;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.eye.api.dtx.ThreadPoolUtils;
import kd.bos.eye.api.dtx.entity.methodparams.MethodParamsInfo;
import kd.bos.eye.api.dtx.entity.methodparams.SearchParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.tenant.TenantInfo;
import kd.bos.util.StringUtils;

public class MethodParamsDao {
    private static final Log logger = LogFactory.getLog(MethodParamsDao.class);
    private static final int MAX_COUNT = 10;

    public List<MethodParamsInfo> getMethodParams(SearchParam searchParam) {
        return ThreadPoolUtils.submit(() -> this.getMethodParams0(searchParam));
    }

    private List<MethodParamsInfo> getMethodParams0(SearchParam searchParam) {
        ArrayList<MethodParamsInfo> methodParamsInfos = new ArrayList();
        if (searchParam != null && StringUtils.isNotEmpty((String)searchParam.getTenantId())) {
            TenantInfo tenantInfo = AccountUtils.getTenantByid((String)searchParam.getTenantId());
            methodParamsInfos = this.getMethodParamsByTenant(tenantInfo);
            return methodParamsInfos;
        }
        List allTenants = AccountUtils.getAllTenantsByCurrentEnv();
        for (TenantInfo tenantInfo : allTenants) {
            methodParamsInfos.addAll(this.getMethodParamsByTenant(tenantInfo));
        }
        return methodParamsInfos.stream().sorted(Comparator.comparingInt(MethodParamsInfo::getSize).reversed()).limit(10L).collect(Collectors.toList());
    }

    private List<MethodParamsInfo> getMethodParamsByTenant(TenantInfo tenantInfo) {
        List allAccounts = AccountUtils.getAllAccounts((String)tenantInfo.getId());
        ArrayList<MethodParamsInfo> methodParamsInfos = new ArrayList<MethodParamsInfo>();
        for (Account account : allAccounts) {
            methodParamsInfos.addAll(this.getMethodParamsByAccount(account));
        }
        return methodParamsInfos.stream().sorted(Comparator.comparingInt(MethodParamsInfo::getSize).reversed()).collect(Collectors.toList());
    }

    private List<MethodParamsInfo> getMethodParamsByAccount(Account account) {
        ArrayList<MethodParamsInfo> methodParamsInfos = new ArrayList<MethodParamsInfo>();
        String sql = "select top 10 t.fxid as xid, t.fbranch_id as branchId, t.fresource as resource, length(t.fparas) as size\nfrom t_cbs_dtx_branch t order by length(t.fparas) desc";
        RequestContextInfo rc = new RequestContextInfo(account.getTenantId(), account.getAccountId());
        try (AutoCloseable ignored = rc.setupThreadRequestContext();){
            DB.query((DBRoute)DBRoute.of((String)"sys"), (String)sql, rs -> {
                while (rs.next()) {
                    MethodParamsInfo methodParamsInfo = new MethodParamsInfo();
                    methodParamsInfo.setXid(rs.getString("xid"));
                    methodParamsInfo.setBranchId(rs.getString("branchId"));
                    methodParamsInfo.setResource(rs.getString("resource"));
                    methodParamsInfo.setSize(rs.getInt("size"));
                    methodParamsInfos.add(methodParamsInfo);
                }
                return null;
            });
        }
        catch (Exception e) {
            logger.error("Getting method params infos by account. Error: ", (Throwable)e);
            return Collections.emptyList();
        }
        return methodParamsInfos;
    }
}

