/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.dtx.dao.reporter.history;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.eye.api.dtx.dao.reporter.SceneInfosDao;
import kd.bos.eye.api.dtx.dao.reporter.history.HistorySceneViewDao;
import kd.bos.eye.api.dtx.entity.reporter.OverViewInfo;
import kd.bos.eye.api.dtx.entity.reporter.ReporterSearchParam;
import kd.bos.eye.api.dtx.entity.reporter.SceneInfo;
import kd.bos.eye.api.dtx.entity.reporter.SceneViewInfo;

public class HistoryOverViewDao {
    public OverViewInfo getOverViewInfo(ReporterSearchParam reporterSearchParam) {
        HistorySceneViewDao historySceneViewDao = new HistorySceneViewDao();
        Map<String, SceneViewInfo> sceneViewInfoMap = this.getAllSceneViewInfos();
        historySceneViewDao.getHistorySceneViewInfos(reporterSearchParam, sceneViewInfoMap);
        return this.totalSceneResult(sceneViewInfoMap);
    }

    private Map<String, SceneViewInfo> getAllSceneViewInfos() {
        HashMap<String, SceneViewInfo> sceneViewInfoMap = new HashMap<String, SceneViewInfo>(16);
        SceneInfosDao sceneInfosDao = new SceneInfosDao();
        List<SceneInfo> sceneInfos = sceneInfosDao.getScenesInfos();
        for (SceneInfo sceneInfo : sceneInfos) {
            sceneViewInfoMap.put(sceneInfo.getId(), new SceneViewInfo(sceneInfo.getId(), sceneInfo.getCode(), sceneInfo.getName()));
        }
        return sceneViewInfoMap;
    }

    private OverViewInfo totalSceneResult(Map<String, SceneViewInfo> sceneViewInfoMap) {
        int total = 0;
        int success = 0;
        int rollback = 0;
        int exception = 0;
        int autoRepair = 0;
        int manualRepair = 0;
        int notRepair = 0;
        for (SceneViewInfo sceneViewInfo : sceneViewInfoMap.values()) {
            if (sceneViewInfo == null) continue;
            total += sceneViewInfo.getTotal().intValue();
            success += sceneViewInfo.getSuccess().intValue();
            rollback += sceneViewInfo.getRollback().intValue();
            exception += sceneViewInfo.getException().intValue();
            autoRepair += sceneViewInfo.getAutoRepair().intValue();
            manualRepair += sceneViewInfo.getManualRepair().intValue();
            notRepair += sceneViewInfo.getNotRepair().intValue();
        }
        return new OverViewInfo(total, success, rollback, exception, autoRepair, manualRepair, notRepair);
    }
}

