/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.dtx.dao.reporter.history;

import java.util.List;
import java.util.Map;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.RequestContextInfo;
import kd.bos.dc.api.model.Account;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.eye.api.dtx.ThreadPoolUtils;
import kd.bos.eye.api.dtx.entity.reporter.ReporterSearchParam;
import kd.bos.eye.api.dtx.entity.reporter.SceneViewInfo;
import kd.bos.eye.api.dtx.sql.HistorySQL;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.tenant.TenantInfo;
import kd.bos.util.StringUtils;

public class HistorySceneViewDao {
    private static final Log logger = LogFactory.getLog(HistorySceneViewDao.class);

    public Map<String, SceneViewInfo> getHistorySceneViewInfos(ReporterSearchParam reporterSearchParam, Map<String, SceneViewInfo> sceneViewInfoMap) {
        return ThreadPoolUtils.submit(() -> this.getHistorySceneViewInfos0(reporterSearchParam, sceneViewInfoMap));
    }

    private Map<String, SceneViewInfo> getHistorySceneViewInfos0(ReporterSearchParam reporterSearchParam, Map<String, SceneViewInfo> sceneViewInfoMap) {
        if (reporterSearchParam != null && StringUtils.isNotEmpty((String)reporterSearchParam.getTenantId())) {
            TenantInfo tenantInfo = AccountUtils.getTenantByid((String)reporterSearchParam.getTenantId());
            this.getHistorySceneViewInfosByTenant(tenantInfo, reporterSearchParam, sceneViewInfoMap);
            return sceneViewInfoMap;
        }
        List allTenants = AccountUtils.getAllTenantsByCurrentEnv();
        for (TenantInfo tenantInfo : allTenants) {
            this.getHistorySceneViewInfosByTenant(tenantInfo, reporterSearchParam, sceneViewInfoMap);
        }
        return sceneViewInfoMap;
    }

    private void getHistorySceneViewInfosByTenant(TenantInfo tenantInfo, ReporterSearchParam reporterSearchParam, Map<String, SceneViewInfo> sceneViewInfoMap) {
        if (reporterSearchParam != null && StringUtils.isNotEmpty((String)reporterSearchParam.getAccountId())) {
            Account account = new Account();
            account.setAccountId(reporterSearchParam.getAccountId());
            account.setTenantId(reporterSearchParam.getTenantId());
            this.getHistorySceneViewInfosByAccount(account, reporterSearchParam, sceneViewInfoMap);
            return;
        }
        List allAccount = AccountUtils.getAllAccounts((String)tenantInfo.getId());
        for (Account account : allAccount) {
            this.getHistorySceneViewInfosByAccount(account, reporterSearchParam, sceneViewInfoMap);
        }
    }

    private void getHistorySceneViewInfosByAccount(Account account, ReporterSearchParam reporterSearchParam, Map<String, SceneViewInfo> sceneViewInfoMap) {
        RequestContextInfo rc = new RequestContextInfo(account.getTenantId(), account.getAccountId());
        try (AutoCloseable ignored = rc.setupThreadRequestContext();){
            Map<String, Object> sceneViewSqlAndParams = HistorySQL.SCENE_VIEW_SQL.getCompleteSql(reporterSearchParam);
            DB.query((DBRoute)DBRoute.of((String)"sys"), (String)((String)sceneViewSqlAndParams.get("sql")), (Object[])((Object[])sceneViewSqlAndParams.get("params")), rs -> {
                while (rs.next()) {
                    String sceneId = rs.getString("sceneId");
                    SceneViewInfo sceneViewInfo = (SceneViewInfo)sceneViewInfoMap.get(sceneId);
                    sceneViewInfo.setTotal(rs.getInt("totals"));
                    sceneViewInfo.setSuccess(rs.getInt("successes"));
                    sceneViewInfo.setException(rs.getInt("exceptions"));
                    sceneViewInfo.setRollback(rs.getInt("rollbacks"));
                    sceneViewInfo.setAutoRepair(rs.getInt("autoRepairs"));
                    sceneViewInfo.setManualRepair(rs.getInt("manualRepairs"));
                    sceneViewInfo.setNotRepair(rs.getInt("notRepairs"));
                }
                return null;
            });
        }
        catch (Exception e) {
            logger.error("Getting dtx history sceneView infos by account. Error: ", (Throwable)e);
        }
    }
}

