/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.dtx.dao.reporter.history;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.RequestContextInfo;
import kd.bos.dc.api.model.Account;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.eye.api.dtx.ThreadPoolUtils;
import kd.bos.eye.api.dtx.entity.reporter.CommonInfo;
import kd.bos.eye.api.dtx.entity.reporter.ReporterSearchParam;
import kd.bos.eye.api.dtx.entity.reporter.TenantViewDetailInfo;
import kd.bos.eye.api.dtx.entity.reporter.TenantViewInfo;
import kd.bos.eye.api.dtx.sql.HistorySQL;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.tenant.TenantInfo;
import kd.bos.util.StringUtils;

public class HistoryTenantViewDao {
    private static final Log logger = LogFactory.getLog(HistoryTenantViewDao.class);

    public List<TenantViewDetailInfo> getHistoryTenantViewInfos(ReporterSearchParam reporterSearchParam) {
        return ThreadPoolUtils.submit(() -> this.getHistoryTenantViewInfos0(reporterSearchParam));
    }

    private List<TenantViewDetailInfo> getHistoryTenantViewInfos0(ReporterSearchParam reporterSearchParam) {
        ArrayList<TenantViewDetailInfo> tenantViewDetailInfos = new ArrayList<TenantViewDetailInfo>(10);
        if (reporterSearchParam != null && StringUtils.isNotEmpty((String)reporterSearchParam.getTenantId())) {
            TenantInfo tenantInfo = AccountUtils.getTenantByid((String)reporterSearchParam.getTenantId());
            TenantViewDetailInfo tenantViewDetailInfo = new TenantViewDetailInfo(tenantInfo.getId(), tenantInfo.getName(), this.getHistoryTenantViewInfosByTenant(tenantInfo, reporterSearchParam));
            tenantViewDetailInfos.add(tenantViewDetailInfo);
            return tenantViewDetailInfos;
        }
        List allTenants = AccountUtils.getAllTenantsByCurrentEnv();
        for (TenantInfo tenantInfo : allTenants) {
            TenantViewDetailInfo tenantViewDetailInfo = new TenantViewDetailInfo(tenantInfo.getId(), tenantInfo.getName(), this.getHistoryTenantViewInfosByTenant(tenantInfo, reporterSearchParam));
            tenantViewDetailInfos.add(tenantViewDetailInfo);
        }
        return tenantViewDetailInfos;
    }

    private Map<String, CommonInfo> getHistoryTenantViewInfosByTenant(TenantInfo tenantInfo, ReporterSearchParam reporterSearchParam) {
        HashMap<String, CommonInfo> totalResultMap = new HashMap<String, CommonInfo>(16);
        if (reporterSearchParam != null && StringUtils.isNotEmpty((String)reporterSearchParam.getAccountId())) {
            Account account = new Account();
            account.setAccountId(reporterSearchParam.getAccountId());
            account.setTenantId(reporterSearchParam.getTenantId());
            totalResultMap.put(account.getAccountId(), this.getHistoryTenantViewInfosByAccount(account, reporterSearchParam));
            return totalResultMap;
        }
        List allAccount = AccountUtils.getAllAccounts((String)tenantInfo.getId());
        for (Account account : allAccount) {
            totalResultMap.put(account.getAccountId(), this.getHistoryTenantViewInfosByAccount(account, reporterSearchParam));
        }
        return totalResultMap;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private CommonInfo getHistoryTenantViewInfosByAccount(Account account, ReporterSearchParam reporterSearchParam) {
        CommonInfo commonInfo2 = new CommonInfo();
        RequestContextInfo rc = new RequestContextInfo(account.getTenantId(), account.getAccountId());
        try (AutoCloseable ignored = rc.setupThreadRequestContext();){
            Map<String, Object> tenantViewSqlAndParams = HistorySQL.TENANT_VIEW_SQL.getCompleteSql(reporterSearchParam);
            DB.query((DBRoute)DBRoute.of((String)"sys"), (String)((String)tenantViewSqlAndParams.get("sql")), (Object[])((Object[])tenantViewSqlAndParams.get("params")), rs -> {
                while (rs.next()) {
                    commonInfo2.setTotal(rs.getInt("totals"));
                    commonInfo2.setSuccess(rs.getInt("successes"));
                    commonInfo2.setException(rs.getInt("exceptions"));
                    commonInfo2.setRollback(rs.getInt("rollbacks"));
                    commonInfo2.setAutoRepair(rs.getInt("autoRepairs"));
                    commonInfo2.setManualRepair(rs.getInt("manualRepairs"));
                    commonInfo2.setNotRepair(rs.getInt("notRepairs"));
                }
                return null;
            });
            CommonInfo commonInfo = commonInfo2;
            return commonInfo;
        }
        catch (Exception e) {
            logger.error("Getting history tenant view info by account. Error: ", (Throwable)e);
            return null;
        }
    }

    public List<TenantViewInfo> translate(List<TenantViewDetailInfo> tenantViewDetailInfos) {
        ArrayList<TenantViewInfo> tenantViewInfos = new ArrayList<TenantViewInfo>(10);
        for (TenantViewDetailInfo tenantViewDetailInfo : tenantViewDetailInfos) {
            TenantViewInfo tenantViewInfo = new TenantViewInfo();
            tenantViewInfo.setTenantId(tenantViewDetailInfo.getTenantId());
            this.totalAccountResult(tenantViewDetailInfo.getResultMap(), tenantViewInfo);
            tenantViewInfos.add(tenantViewInfo);
        }
        return tenantViewInfos;
    }

    private void totalAccountResult(Map<String, CommonInfo> resultMap, TenantViewInfo tenantViewInfo) {
        int total = 0;
        int success = 0;
        int rollback = 0;
        int exception = 0;
        int autoRepair = 0;
        int manualRepair = 0;
        int notRepair = 0;
        for (CommonInfo commonInfo : resultMap.values()) {
            if (commonInfo == null) continue;
            total += commonInfo.getTotal().intValue();
            success += commonInfo.getSuccess().intValue();
            rollback += commonInfo.getRollback().intValue();
            exception += commonInfo.getException().intValue();
            autoRepair += commonInfo.getAutoRepair().intValue();
            manualRepair += commonInfo.getManualRepair().intValue();
            notRepair += commonInfo.getNotRepair().intValue();
        }
        tenantViewInfo.setMultiField(total, success, rollback, exception, autoRepair, manualRepair, notRepair);
    }
}

