/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.dtx.sql;

import java.io.Serializable;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import kd.bos.eye.api.dtx.entity.reporter.ReporterSearchParam;
import kd.bos.util.StringUtils;

public enum CommonSQL {
    QUERY_TOTAL_SQL("select count(t.fxid) as totals from t_cbs_dtx_transaction t where (1=1)"),
    QUERY_SUCCESS_SQL("select count(t.fxid) as successes from t_cbs_dtx_transaction t where t.fstatus = 4"),
    QUERY_ROLLBACK_SQL("select count(t.fxid) as rollbacks from t_cbs_dtx_transaction t where t.fstatus = 5"),
    QUERY_EXCEPTION_SQL("select count(t.fxid) as exceptions from t_cbs_dtx_transaction t where t.fxid in (select distinct fxid from t_cbs_dtx_logs where fresult in (0,-1))"),
    QUERY_AUTO_REPAIR_SQL("select count(t.fxid) as autoRepairs from t_cbs_dtx_retry_stat r inner join t_cbs_dtx_transaction t on r.fxid = t.fxid where t.fstatus = 4 and r.ftrigger_type = 3 and r.fxid not in (select r1.fxid from t_cbs_dtx_retry_stat r1 where r1.ftrigger_type = 2)"),
    QUERY_MANUAL_REPAIR_SQL("select count(t.fxid) as manualRepairs from t_cbs_dtx_retry_stat r inner join t_cbs_dtx_transaction t on r.fxid = t.fxid where t.fstatus = 4 and r.ftrigger_type = 2"),
    QUERY_NOT_REPAIR_SQL("select count(t.fxid) as notRepairs from t_cbs_dtx_transaction t where t.fstatus not in (4, 5) and t.fxid in (select distinct fxid from t_cbs_dtx_logs where fresult in (0,-1))"),
    QUERY_NOT_REPAIR_XID_SQL("select t.fxid from t_cbs_dtx_transaction t where t.fstatus not in (4, 5) and t.fxid in (select distinct fxid from t_cbs_dtx_logs where fresult in (0,-1))"),
    QUERY_NOT_REPAIR_INFO_SQL("select t.fxid as xid, t.fstatus as status, s.fname as sceneName, t.fcreate_time as createTime from t_cbs_dtx_transaction t left join t_cbs_dtx_tx_scenes as s on s.fid = t.fscenes_tx_id where t.fstatus not in (4, 5) \nand t.fxid in (select distinct fxid from t_cbs_dtx_logs where fresult in (0,-1))"),
    QUERY_MANUAL_REPAIR_INFO_SQL("select t.fxid as xid, t.fstatus as status, s.fname as sceneName, t.fcreate_time as createTime\nfrom t_cbs_dtx_retry_stat r inner join t_cbs_dtx_transaction t on r.fxid = t.fxid left join t_cbs_dtx_tx_scenes s on t.fscenes_tx_id = s.fid\nwhere t.fstatus = 4 and r.ftrigger_type = 2"),
    QUERY_AUTO_REPAIR_INFO_SQL("select t.fxid as xid, t.fstatus as status, s.fname as sceneName, t.fcreate_time as createTime\nfrom t_cbs_dtx_retry_stat r inner join t_cbs_dtx_transaction t on r.fxid = t.fxid left join t_cbs_dtx_tx_scenes s on t.fscenes_tx_id = s.fid\nwhere t.fstatus = 4 and r.ftrigger_type = 3 and r.fxid not in \n(select r1.fxid from t_cbs_dtx_retry_stat r1 where r1.ftrigger_type = 2)"),
    QUERY_EXCEPTION_INFO_SQL("select t.fxid as xid, t.fstatus as status, s.fname as sceneName, t.fcreate_time as createTime\nfrom t_cbs_dtx_transaction t left join t_cbs_dtx_tx_scenes s on t.fscenes_tx_id = s.fid\nwhere t.fxid in (select distinct fxid from t_cbs_dtx_logs where fresult in (0,-1))"),
    QUERY_ROLLBACK_INFO_SQL("select t.fxid as xid, t.fstatus as status, s.fname as sceneName, t.fcreate_time as createTime\nfrom t_cbs_dtx_transaction t left join t_cbs_dtx_tx_scenes s on t.fscenes_tx_id = s.fid\nwhere t.fstatus = 5");

    private final String sql;

    private CommonSQL(String sql) {
        this.sql = sql;
    }

    public String getSql() {
        return this.sql;
    }

    public Map<String, Object> getCompleteSql(ReporterSearchParam reporterSearchParam) {
        HashMap<String, Object> completeResult = new HashMap<String, Object>();
        if (reporterSearchParam == null) {
            completeResult.put("sql", this.sql);
            completeResult.put("params", new Object[0]);
            return completeResult;
        }
        String sceneId = reporterSearchParam.getSceneId();
        Integer type = reporterSearchParam.getType();
        String[] dateRange = reporterSearchParam.getDateRange();
        StringBuilder whereSql = new StringBuilder(this.sql);
        ArrayList<Serializable> params = new ArrayList<Serializable>();
        if (StringUtils.isNotEmpty((String)sceneId)) {
            whereSql.append(" and t.fscenes_tx_id = ?");
            params.add(Long.valueOf(sceneId));
        }
        if (type != null) {
            whereSql.append(" and t.ftx_type = ?");
            params.add(type);
        } else if (this == QUERY_ROLLBACK_INFO_SQL) {
            whereSql.append(" and t.ftx_type = ?");
            params.add(Integer.valueOf(0));
        }
        if (dateRange != null) {
            whereSql.append(" and (t.fcreate_time >= ?").append(" and t.fcreate_time < ?)");
            params.add(LocalDate.parse(dateRange[0]));
            params.add(LocalDate.parse(dateRange[1]).plusDays(1L));
        }
        completeResult.put("sql", whereSql.toString());
        completeResult.put("params", params.toArray());
        return completeResult;
    }
}

