/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.dtx.sql;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import kd.bos.eye.api.dtx.entity.reporter.ReporterSearchParam;
import kd.bos.util.StringUtils;

public enum HistorySQL {
    TENANT_VIEW_SQL("select sum(t.ftotal) as totals,sum(t.fsuccess) as successes,sum(t.fexception) as exceptions,sum(t.frollback) as rollbacks,sum(t.fauto_repair) as autoRepairs,sum(t.fmanual_repair) as manualRepairs,sum(t.fnot_repair) as notRepairs from t_cbs_dtx_archive t where (1=1)%s"),
    SCENE_VIEW_SQL("select sum(t.ftotal) as totals,sum(t.fsuccess) as successes,sum(t.fexception) as exceptions,sum(t.frollback) as rollbacks,sum(t.fauto_repair) as autoRepairs,sum(t.fmanual_repair) as manualRepairs,sum(t.fnot_repair) as notRepairs,t.fscenes_tx_id as sceneId from t_cbs_dtx_archive t where (1=1)%s group by t.fscenes_tx_id"),
    NOT_REPAIR_SQL("select t.fxid as xid, t.fstatus as status, s.fname as sceneName, t.fcreate_time as createTime from t_cbs_dtx_transaction t left join t_cbs_dtx_tx_scenes as s on s.fid = t.fscenes_tx_id right join t_cbs_dtx_not_repair tcdnr on t.fxid = tcdnr.fxid where (1=1)%s");

    private final String sql;

    private HistorySQL(String sql) {
        this.sql = sql;
    }

    public String getSql() {
        return this.sql;
    }

    public Map<String, Object> getCompleteSql(ReporterSearchParam reporterSearchParam) {
        HashMap<String, Object> completeResult = new HashMap<String, Object>();
        if (reporterSearchParam == null) {
            completeResult.put("sql", String.format(this.sql, ""));
            completeResult.put("params", new Object[0]);
            return completeResult;
        }
        String sceneId = reporterSearchParam.getSceneId();
        String[] dateRange = reporterSearchParam.getDateRange();
        StringBuilder whereSql = new StringBuilder();
        ArrayList<Comparable<Long>> params = new ArrayList<Comparable<Long>>();
        if (StringUtils.isNotEmpty((String)sceneId)) {
            whereSql.append(" and t.fscenes_tx_id = ?");
            params.add(Long.valueOf(sceneId));
        }
        if (dateRange != null) {
            whereSql.append(" and (t.farchive_date >= ?").append(" and t.farchive_date < ?)");
            params.add(LocalDate.parse(dateRange[0]));
            params.add(LocalDate.parse(dateRange[1]).plusDays(1L));
        }
        completeResult.put("sql", String.format(this.sql, whereSql));
        completeResult.put("params", params.toArray());
        return completeResult;
    }
}

