/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.dtx.sql;

import java.io.Serializable;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import kd.bos.eye.api.dtx.entity.reporter.ReporterSearchParam;
import kd.bos.util.StringUtils;

public enum SceneViewSQL {
    QUERY_TOTAL_SQL("select count(t.fxid) as totals, s.fid as sceneId, s.fcode as sceneCode, s.fname as sceneName from t_cbs_dtx_transaction t right join t_cbs_dtx_tx_scenes s on t.fscenes_tx_id = s.fid where (1=1)%s group by s.fid,s.fcode,s.fname"),
    QUERY_SUCCESS_SQL("select count(t.fxid) as successes, s.fid as sceneId, s.fcode as sceneCode, s.fname as sceneName from t_cbs_dtx_transaction t right join t_cbs_dtx_tx_scenes s on t.fscenes_tx_id = s.fid where t.fstatus = 4%s group by s.fid,s.fcode,s.fname"),
    QUERY_ROLLBACK_SQL("select count(t.fxid) as rollbacks, s.fid as sceneId, s.fcode as sceneCode, s.fname as sceneName from t_cbs_dtx_transaction t right join t_cbs_dtx_tx_scenes s on t.fscenes_tx_id = s.fid where t.fstatus = 5%s group by s.fid,s.fcode,s.fname"),
    QUERY_EXCEPTION_SQL("select count(t.fxid) as exceptions, s.fid as sceneId, s.fcode as sceneCode, s.fname as sceneName from t_cbs_dtx_transaction t right join t_cbs_dtx_tx_scenes s on t.fscenes_tx_id = s.fid where t.fxid in (select distinct fxid from t_cbs_dtx_logs where fresult in (0,-1))%s group by s.fid,s.fcode,s.fname"),
    QUERY_AUTO_REPAIR_SQL("select count(t.fxid) as autoRepairs, s.fid as sceneId, s.fcode as sceneCode, s.fname as sceneName from t_cbs_dtx_retry_stat r inner join t_cbs_dtx_transaction t on r.fxid = t.fxid right join t_cbs_dtx_tx_scenes s on t.fscenes_tx_id = s.fid where t.fstatus = 4 and r.ftrigger_type = 3 and r.fxid not in (select r1.fxid from t_cbs_dtx_retry_stat r1 where r1.ftrigger_type = 2)%s group by s.fid,s.fcode,s.fname"),
    QUERY_MANUAL_REPAIR_SQL("select count(t.fxid) as manualRepairs, s.fid as sceneId, s.fcode as sceneCode, s.fname as sceneName from t_cbs_dtx_retry_stat r inner join t_cbs_dtx_transaction t on r.fxid = t.fxid right join t_cbs_dtx_tx_scenes s on t.fscenes_tx_id = s.fid where t.fstatus = 4 and r.ftrigger_type = 2%s group by s.fid,s.fcode,s.fname"),
    QUERY_NOT_REPAIR_SQL("select count(t.fxid) as notRepairs, s.fid as sceneId, s.fcode as sceneCode, s.fname as sceneName from t_cbs_dtx_transaction t right join t_cbs_dtx_tx_scenes s on t.fscenes_tx_id = s.fid where t.fstatus not in (4, 5) and t.fxid in (select distinct fxid from t_cbs_dtx_logs where fresult in (0,-1))%s group by s.fid,s.fcode,s.fname"),
    QUERY_NOT_REPAIR_XID_SQL("select t.fxid from t_cbs_dtx_transaction t where t.fstatus not in (4, 5) and t.fxid in (select distinct fxid from t_cbs_dtx_logs where fresult in (0,-1))%s");

    private final String sql;

    private SceneViewSQL(String sql) {
        this.sql = sql;
    }

    public String getSql() {
        return this.sql;
    }

    public Map<String, Object> getCompleteSql(ReporterSearchParam reporterSearchParam) {
        HashMap<String, Object> completeResult = new HashMap<String, Object>();
        if (reporterSearchParam == null) {
            completeResult.put("sql", String.format(this.sql, ""));
            completeResult.put("params", new Object[0]);
            return completeResult;
        }
        String sceneId = reporterSearchParam.getSceneId();
        Integer type = reporterSearchParam.getType();
        String[] dateRange = reporterSearchParam.getDateRange();
        StringBuilder whereSql = new StringBuilder();
        ArrayList<Serializable> params = new ArrayList<Serializable>();
        if (StringUtils.isNotEmpty((String)sceneId)) {
            whereSql.append(" and t.fscenes_tx_id = ?");
            params.add(Long.valueOf(sceneId));
        }
        if (type != null) {
            whereSql.append(" and t.ftx_type = ?");
            params.add(type);
        }
        if (dateRange != null) {
            whereSql.append(" and (t.fcreate_time >= ?").append(" and t.fcreate_time < ?)");
            params.add(LocalDate.parse(dateRange[0]));
            params.add(LocalDate.parse(dateRange[1]).plusDays(1L));
        }
        completeResult.put("sql", String.format(this.sql, whereSql));
        completeResult.put("params", params.toArray());
        return completeResult;
    }
}

