/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.filemanager;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import kd.bos.eye.api.alarm.db.AlarmBaseDbHelper;
import kd.bos.eye.api.filemanager.IllegalPathRecordInfo;
import kd.bos.government.metadata.MetadataFactory;
import kd.bos.government.metadata.Request;
import kd.bos.government.metadata.Result;
import kd.bos.government.metadata.db.DBRequest;

public class IllegalPathDbHelper
extends AlarmBaseDbHelper {
    private static final String TABLE_NAME = "T_MONITOR_ILLEGALFILEPATH";
    private static final String ID_FIELD = "fid";
    private static final String PATH_FIELD = "fpath";
    private static final String TENANTID_FIELD = "ftenantid";
    private static final String ACCOUNT_FIELD = "faccountid";
    private static final String LASTACCESSTIME_FIELD = "flastaccesstime";
    private static final String MSG_FIELD = "fmsg";
    private static final String[] FIELD_ARR = new String[]{"fid", "fpath", "ftenantid", "faccountid", "flastaccesstime", "fmsg"};

    private static String[] getUpdateFields(String ... excludeFields) {
        ArrayList<String> updateFields = new ArrayList<String>(8);
        for (String field : FIELD_ARR) {
            boolean isExField = false;
            for (String exField : excludeFields) {
                if (!field.equals(exField)) continue;
                isExField = true;
                break;
            }
            if (isExField) continue;
            updateFields.add(field);
        }
        return updateFields.toArray(new String[0]);
    }

    public static void saveRecord(IllegalPathRecordInfo recordInfo) throws IOException {
        DBRequest dbRequest = new DBRequest();
        long id = recordInfo.getId();
        if (IllegalPathDbHelper.getRecordInfo(id) == null) {
            ArrayList insertList = new ArrayList(10);
            Collections.addAll(insertList, recordInfo.getId(), recordInfo.getPath(), recordInfo.getTenantId(), recordInfo.getAccountId(), recordInfo.getLastAccessTime(), recordInfo.getMsg());
            String insertSql = IllegalPathDbHelper.buildInsertSql(TABLE_NAME, FIELD_ARR.length);
            dbRequest.setInsertRequest(new DBRequest.InsertRequest(insertSql, insertList));
            MetadataFactory.getStatement().executeInsert((Request)dbRequest);
        } else {
            String updateSql = IllegalPathDbHelper.buildUpdateSql(TABLE_NAME, IllegalPathDbHelper.getUpdateFields(ID_FIELD), new String[]{ID_FIELD});
            ArrayList updateList = new ArrayList(10);
            Collections.addAll(updateList, recordInfo.getPath(), recordInfo.getTenantId(), recordInfo.getAccountId(), recordInfo.getLastAccessTime(), recordInfo.getMsg(), recordInfo.getId());
            dbRequest.setUpdateRequest(new DBRequest.UpdateRequest(updateSql, updateList));
            MetadataFactory.getStatement().executeUpdate((Request)dbRequest);
        }
    }

    public static IllegalPathRecordInfo getRecordInfo(String path, String tenantId, String accountId) throws IOException {
        ArrayList queryList = new ArrayList(1);
        Collections.addAll(queryList, path, tenantId, accountId);
        DBRequest dbRequest = new DBRequest();
        String querySql = IllegalPathDbHelper.buildQuerySql(TABLE_NAME, FIELD_ARR, new String[]{PATH_FIELD, TENANTID_FIELD, ACCOUNT_FIELD});
        dbRequest.setQueryRequest(new DBRequest.QueryRequest(querySql, queryList));
        List results = MetadataFactory.getStatement().executeQuery((Request)dbRequest);
        if (!results.isEmpty()) {
            return IllegalPathDbHelper.resultToRecordInfo((Result)results.get(0));
        }
        return null;
    }

    public static IllegalPathRecordInfo getRecordInfo(long id) throws IOException {
        ArrayList queryList = new ArrayList(1);
        Collections.addAll(queryList, id);
        DBRequest dbRequest = new DBRequest();
        String querySql = IllegalPathDbHelper.buildQuerySql(TABLE_NAME, FIELD_ARR, new String[]{ID_FIELD});
        dbRequest.setQueryRequest(new DBRequest.QueryRequest(querySql, queryList));
        List results = MetadataFactory.getStatement().executeQuery((Request)dbRequest);
        if (!results.isEmpty()) {
            return IllegalPathDbHelper.resultToRecordInfo((Result)results.get(0));
        }
        return null;
    }

    private static IllegalPathRecordInfo resultToRecordInfo(Result result) throws IOException {
        IllegalPathRecordInfo recordInfo = new IllegalPathRecordInfo();
        recordInfo.setId(Long.parseLong(result.getString(ID_FIELD)));
        recordInfo.setPath(result.getString(PATH_FIELD));
        recordInfo.setTenantId(result.getString(TENANTID_FIELD));
        recordInfo.setAccountId(result.getString(ACCOUNT_FIELD));
        recordInfo.setMsg(result.getString(MSG_FIELD));
        recordInfo.setLastAccessTime(IllegalPathDbHelper.parseStrToLDT(result.getString(LASTACCESSTIME_FIELD)));
        return recordInfo;
    }
}

