/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.flamegraphs;

import java.io.InputStream;
import java.util.TimerTask;
import kd.bos.eye.api.flamegraphs.FlameGraphHandler;
import kd.bos.eye.api.flamegraphs.FlameGraphs;
import kd.bos.eye.api.flamegraphs.FlameGraphsMsg;
import kd.bos.eye.api.flamegraphs.Status;
import kd.bos.eye.api.flamegraphs.profiler.utils.IOUtils;
import kd.bos.eye.api.flamegraphs.vo.FlameGraphVO;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.monitor.lang.LangRes;

class FlameGraphResultTask
extends TimerTask {
    private static final Log LOGGER = LogFactory.getLog(FlameGraphResultTask.class);
    private FlameGraphVO flameGraphVO;

    public FlameGraphResultTask(FlameGraphVO flameGraphVO) {
        this.flameGraphVO = flameGraphVO;
    }

    @Override
    public void run() {
        int maxWaitTimes = FlameGraphHandler.getTaskMaxWaitTimes();
        int failTime = 0;
        while (failTime < maxWaitTimes) {
            FlameGraphsMsg flameGraphsMsg = null;
            try {
                flameGraphsMsg = FlameGraphs.getMsg(this.flameGraphVO.getFlameGraphId());
            }
            catch (Exception ex) {
                LOGGER.error("FlameGraphs.getMsg error:{}", (Object)ex.getMessage());
                this.flameGraphVO.setTaskStatus(Status.ERROR.toString());
                this.flameGraphVO.setErrorMsg(LangRes.get((String)"FlameGraphHandler_6", (String)"\u751f\u6210\u706b\u7130\u56fe\u8d85\u65f6", (Object[])new Object[0]));
                FlameGraphHandler.updateFlameGraphVO(this.flameGraphVO);
                return;
            }
            try {
                if (flameGraphsMsg == null || flameGraphsMsg.getStatus() == Status.ERROR) {
                    this.flameGraphVO.setTaskStatus(Status.ERROR.toString());
                    String msg = flameGraphsMsg == null ? "" : flameGraphsMsg.getMsg();
                    this.flameGraphVO.setErrorMsg(msg);
                    FlameGraphHandler.updateFlameGraphVO(this.flameGraphVO);
                    return;
                }
                if (flameGraphsMsg.getStatus() == Status.OK) {
                    try (InputStream inputStream = FlameGraphs.getInputStream(this.flameGraphVO.getFlameGraphId());){
                        LOGGER.info("inputStreamSize={}", (Object)inputStream.available());
                        String fileString = IOUtils.toString(inputStream);
                        LOGGER.info("fileStringSize={}", (Object)fileString.length());
                        this.flameGraphVO.setFileSource(fileString);
                        this.flameGraphVO.setTaskStatus(Status.OK.toString());
                        FlameGraphHandler.updateFlameGraphVO(this.flameGraphVO);
                    }
                    return;
                }
                if (flameGraphsMsg.getStatus() == Status.RUNNING) {
                    ++failTime;
                }
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException e) {
                    this.flameGraphVO.setErrorMsg(LangRes.get((String)"FlameGraphHandler_7", (String)"FlameGraphResultTask\u7ebf\u7a0b\u88ab\u4e2d\u65ad", (Object[])new Object[0]));
                    this.flameGraphVO.setTaskStatus(Status.ERROR.toString());
                    FlameGraphHandler.updateFlameGraphVO(this.flameGraphVO);
                    return;
                }
            }
            catch (Exception ex) {
                LOGGER.error("flameGraphResultTask run error:{}", (Object)ex.getMessage());
            }
        }
        this.flameGraphVO.setTaskStatus(Status.ERROR.toString());
        int seconds = Integer.parseInt(this.flameGraphVO.getSampleTimeSeconds()) + FlameGraphHandler.getTaskMaxWaitSeconds();
        String msg = LangRes.get((String)"FlameGraphHandler_8", (String)"\u706b\u7130\u56fe\u4efb\u52a1{0}\u79d2\u5185\u672a\u5b8c\u6210\uff0c\u8ba4\u5b9a\u5931\u8d25", (Object[])new Object[]{seconds});
        this.flameGraphVO.setErrorMsg(msg);
        FlameGraphHandler.updateFlameGraphVO(this.flameGraphVO);
    }
}

