/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.flamegraphs.cache;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.cache.TempFileCache;
import kd.bos.eye.api.flamegraphs.FlameGraphsMsg;
import kd.bos.eye.api.flamegraphs.Status;
import kd.bos.util.StringUtils;

public class FlameGraphsCache {
    private static final String STATUS_KEY = "status";
    private static final String MSG_KEY = "msg";
    private static final String FILE_URL_KEY = "tmpFileUrl";
    private static final int TIMEOUT_SECONDS = 3600;
    private static DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache();
    private static TempFileCache tempFileCache = CacheFactory.getCommonCacheFactory().getTempFileCache();

    public static void cacheMsg(String id, FlameGraphsMsg flameGraphsMsg) {
        HashMap<String, String> map = new HashMap<String, String>(2);
        map.put(STATUS_KEY, flameGraphsMsg.getStatus().toString());
        map.put(MSG_KEY, flameGraphsMsg.getMsg());
        cache.put(id, map, 3600);
    }

    public static FlameGraphsMsg getMsg(String id) {
        Map map = cache.getAll(id);
        if (map == null) {
            return null;
        }
        return new FlameGraphsMsg(Status.getValueOf((String)map.get(STATUS_KEY)), (String)map.get(MSG_KEY));
    }

    public static String cacheInputStream(String id, InputStream inputStream) {
        String tmpFileUrl = tempFileCache.saveAsUrl(id + ".html", inputStream, 3600);
        cache.put(id, FILE_URL_KEY, (Object)tmpFileUrl);
        return tmpFileUrl;
    }

    public static InputStream getInputStream(String id) {
        String tmpFileUrl = (String)cache.get(id, FILE_URL_KEY);
        if (StringUtils.isEmpty((String)tmpFileUrl)) {
            return null;
        }
        return tempFileCache.getInputStream(tmpFileUrl);
    }

    public static void remove(String id) {
        String tmpFileUrl = (String)cache.get(id, FILE_URL_KEY);
        if (StringUtils.isEmpty((String)tmpFileUrl)) {
            tempFileCache.remove(tmpFileUrl);
        }
        cache.remove(id);
    }
}

