/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.flamegraphs.task;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collections;
import kd.bos.dlock.DLock;
import kd.bos.eye.api.flamegraphs.FlameConfigHandler;
import kd.bos.eye.api.flamegraphs.vo.FlameConfigVO;
import kd.bos.government.metadata.MetadataFactory;
import kd.bos.government.metadata.Request;
import kd.bos.government.metadata.db.DBRequest;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class FlameGraphWork
implements Runnable {
    private static final Log LOGGER = LogFactory.getLog(FlameGraphWork.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        DLock dLock = DLock.create((String)"FlameGraphClear");
        try {
            if (!dLock.tryLock()) {
                return;
            }
            LOGGER.info("flameGraph history data clear task start...");
            DBRequest dbRequest = new DBRequest();
            String deleteSql = "delete from t_monitor_flamegraph where fcreatetime < ?";
            ArrayList deleteList = new ArrayList(1);
            FlameConfigVO flameConfigVO = FlameConfigHandler.getFlameConfigVO();
            long days = Long.parseLong(flameConfigVO.getMaxStoreDays());
            Collections.addAll(deleteList, LocalDate.now().minusDays(days));
            dbRequest.setDeleteRequest(new DBRequest.DeleteRequest(deleteSql, deleteList));
            DBRequest.DeleteRequest deleteRequest = new DBRequest.DeleteRequest(deleteSql, deleteList);
            dbRequest.setDeleteRequest(deleteRequest);
            int deleteSize = MetadataFactory.getStatement().executeDelete((Request)dbRequest);
            LOGGER.info("flameGraph history data clear task end...,deleteSize=" + deleteSize);
        }
        catch (Exception e) {
            LOGGER.error("flameGraph history execute error:{}", (Object)e.getMessage());
        }
        finally {
            dLock.unlock();
        }
    }
}

