/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.healthcheck.spi;

import com.alibaba.fastjson.JSONObject;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.encrypt.Encrypters;
import kd.bos.eye.api.healthcheck.spi.CheckResult;
import kd.bos.eye.api.healthcheck.spi.HealthCheckConfig;
import kd.bos.eye.api.healthcheck.spi.HealthCheckService;
import kd.bos.eye.api.healthcheck.spi.service.ServiceHealthCheckExecutor;
import kd.bos.eye.util.ExchangeVueUtils;
import kd.bos.util.JSONUtils;
import kd.bos.util.StringUtils;

public class ClusterHealthCheckHandler
implements HttpHandler {
    private static final DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache();
    private static final JSONObject JSON_OBJECT = new JSONObject();
    private static final String CHECK_TIME_KEY = "monitor-health-check-time-key";
    private static final String LOCK_KEY = "monitor-health-check-lock-key";
    private String lastValue;

    @Override
    public void handle(HttpExchange exchange) throws IOException {
        JSONObject response;
        JSONObject params = ExchangeVueUtils.parseJsonFromPost(exchange, JSONObject.class);
        if (params != null) {
            JSONObject auth = params.getJSONObject("auth");
            String userName = auth.getString("userName");
            String passwd = auth.getString("password");
            if (StringUtils.isEmpty((String)userName) || StringUtils.isEmpty((String)passwd)) {
                response = this.ofResponse(-1, "[ERROR] access denied,userName or password is empty", JSON_OBJECT);
            } else {
                boolean isAllow = HealthCheckConfig.checkAuth(userName, Encrypters.decode((String)passwd));
                if (isAllow) {
                    JSONObject param = params.getJSONObject("params");
                    if (StringUtils.isNotEmpty((String)param.getString("instanceId"))) {
                        CheckResult result = ServiceHealthCheckExecutor.checkMyself();
                        this.writeJson(JSONUtils.toString((Object)result), exchange);
                        return;
                    }
                    long lastCheckTime = this.lastCheckTime();
                    if (System.currentTimeMillis() - lastCheckTime < 1000L) {
                        this.writeJson(StringUtils.isEmpty((String)this.lastValue) ? this.ofResponse(-1, "[ERROR] too many request in one second", JSON_OBJECT).toJSONString() : this.lastValue, exchange);
                        return;
                    }
                    int timeout = Integer.parseInt(HealthCheckConfig.getConfig("timeout", "6"));
                    cache.put(LOCK_KEY, (Object)"lock", timeout + 3);
                    List<CheckResult> detailCheckResult = HealthCheckService.getDetailCheckResult(params);
                    JSONObject formatResult = HealthCheckService.formatResult(detailCheckResult);
                    int globalStatus = HealthCheckService.computerGlobalStatus(formatResult);
                    String message = "";
                    if (globalStatus == -1) {
                        message = "[ERROR]";
                    } else if (globalStatus == 1) {
                        message = "[WARN]";
                    }
                    if (StringUtils.isNotEmpty((String)HealthCheckService.globalMessage)) {
                        message = HealthCheckService.globalMessage;
                    }
                    response = this.ofResponse(globalStatus, message, formatResult);
                } else {
                    response = this.ofResponse(-1, "[ERROR] access denied,user and password doesn't match,please check MC configuration ", JSON_OBJECT);
                }
            }
        } else {
            response = this.ofResponse(-1, "[ERROR] bad request, http post params is empty", JSON_OBJECT);
        }
        String value = response.toJSONString();
        HashMap<String, String> hashMap = new HashMap<String, String>(2);
        hashMap.put("lastCheckTime", String.valueOf(System.currentTimeMillis()));
        hashMap.put("value", value);
        cache.put(CHECK_TIME_KEY, hashMap);
        cache.remove(LOCK_KEY);
        this.writeJson(value, exchange);
    }

    private void writeJson(String str, HttpExchange exchange) throws IOException {
        byte[] bytes = str.getBytes("UTF-8");
        exchange.getResponseHeaders().set("Content-Type", "application/json; charset=UTF-8");
        exchange.sendResponseHeaders(202, bytes.length);
        exchange.getResponseBody().write(bytes);
        exchange.close();
    }

    private JSONObject ofResponse(int status, String msg, JSONObject detail) {
        JSONObject json = new JSONObject();
        json.put("status", (Object)status);
        json.put("msg", (Object)msg);
        json.put("detail", (Object)detail);
        return json;
    }

    private long lastCheckTime() {
        if (cache.contains(LOCK_KEY)) {
            return System.currentTimeMillis();
        }
        try {
            Map map = cache.getAll(CHECK_TIME_KEY);
            if (map != null && !map.isEmpty()) {
                this.lastValue = (String)map.get("value");
                return Long.parseLong((String)map.get("lastCheckTime"));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 0L;
    }
}

