/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.healthcheck.spi;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import kd.bos.eye.api.healthcheck.spi.CheckResult;
import kd.bos.eye.api.healthcheck.spi.HealthCheck;
import kd.bos.eye.api.healthcheck.spi.HealthCheckConfig;
import kd.bos.eye.api.healthcheck.spi.component.DBCheckExecutor;
import kd.bos.eye.api.healthcheck.spi.component.RedisCheckExecutor;
import kd.bos.eye.api.healthcheck.spi.component.ZookeeperCheckExecutor;
import kd.bos.eye.api.healthcheck.spi.service.ServiceCheckResult;
import kd.bos.eye.api.healthcheck.spi.service.ServiceHealthCheckExecutor;
import kd.bos.util.SafeLogUtils;

public class HealthCheckService {
    private static int checkStatus = 0;
    protected static String globalMessage = "";
    private static List<HealthCheck> componentCheckItems = new ArrayList<HealthCheck>(32);

    public static List<CheckResult> getDetailCheckResult(JSONObject params) {
        long timeout = Long.parseLong(HealthCheckConfig.getConfig("timeout", "6"));
        ArrayList<CheckResult> results = new ArrayList<CheckResult>();
        try {
            int size = componentCheckItems.size();
            checkStatus = 0;
            globalMessage = "";
            CountDownLatch latch = new CountDownLatch(size + 1);
            ServiceHealthCheckExecutor checkExecutor = new ServiceHealthCheckExecutor(params);
            new Thread(() -> {
                try {
                    results.addAll(checkExecutor.check());
                }
                finally {
                    latch.countDown();
                }
            }, "monitor-healthCheck-" + size).start();
            for (int i = 0; i < size; ++i) {
                HealthCheck healthCheck = componentCheckItems.get(i);
                new Thread(() -> {
                    try {
                        results.addAll(healthCheck.check());
                    }
                    finally {
                        latch.countDown();
                    }
                }, "monitor-healthCheck-" + i).start();
            }
            boolean await = latch.await(timeout, TimeUnit.SECONDS);
            if (!await) {
                checkStatus = -1;
                globalMessage = "[ERROR] healthCheck timeout,time is " + timeout + " s,there are still some items to check";
            }
        }
        catch (InterruptedException e) {
            checkStatus = -1;
            globalMessage = "[ERROR] healthCheck is interrupted";
        }
        return results;
    }

    public static JSONObject formatResult(List<CheckResult> results) {
        String available_inst_ratio = HealthCheckConfig.getConfig("available_inst_ratio", "50");
        JSONObject formatResult = new JSONObject();
        HashMap<String, List> formatMap = new HashMap<String, List>(16);
        for (CheckResult result : results) {
            if (result instanceof ServiceCheckResult) {
                ServiceCheckResult ret = (ServiceCheckResult)result;
                String appName = ret.getAppName();
                if (formatMap.containsKey(appName)) {
                    List jsonArray = (List)formatMap.get(appName);
                    jsonArray.add(result);
                    formatMap.put(appName, jsonArray);
                    continue;
                }
                ArrayList<CheckResult> objects = new ArrayList<CheckResult>(8);
                objects.add(result);
                formatMap.put(appName, objects);
                continue;
            }
            ArrayList<CheckResult> components = (ArrayList<CheckResult>)formatResult.getObject("components", List.class);
            if (components == null) {
                components = new ArrayList<CheckResult>(8);
            }
            components.add(result);
            formatResult.put("components", components);
        }
        Iterator iterator = formatMap.entrySet().iterator();
        JSONArray array = new JSONArray();
        while (iterator.hasNext()) {
            JSONObject jsonObject = new JSONObject();
            Map.Entry next = iterator.next();
            List value = (List)next.getValue();
            jsonObject.put("appName", next.getKey());
            int status = HealthCheckService.computerStatus(value);
            jsonObject.put("status", (Object)status);
            jsonObject.put("instances", (Object)value);
            if (status == 0) {
                jsonObject.put("msg", (Object)"[SUCCESS]");
            } else if (status == 1) {
                jsonObject.put("msg", (Object)String.format("[WARN] has service instance check exception,but not more than %s percent", available_inst_ratio));
            } else {
                jsonObject.put("msg", (Object)String.format("[ERROR] exception service node more than %s percent", available_inst_ratio));
            }
            array.add((Object)jsonObject);
        }
        formatResult.put("services", (Object)array);
        return formatResult;
    }

    private static int computerStatus(List<CheckResult> results) {
        boolean isError;
        int errorNum = 0;
        for (CheckResult result : results) {
            if (result.getStatus() != -1) continue;
            ++errorNum;
        }
        boolean bl = isError = (float)errorNum / (float)results.size() * 100.0f >= Float.parseFloat(HealthCheckConfig.getConfig("available_inst_ratio", "50"));
        return isError ? -1 : (errorNum > 0 ? 1 : 0);
    }

    public static int computerGlobalStatus(JSONObject jsonObject) {
        int globalStatus = 0;
        List components = (List)jsonObject.getObject("components", List.class);
        for (CheckResult component : components) {
            globalStatus |= component.getStatus();
        }
        JSONArray jsonArray = jsonObject.getJSONArray("services");
        int size = jsonArray.size();
        for (int i = 0; i < size; ++i) {
            JSONObject object = jsonArray.getJSONObject(i);
            globalStatus |= object.getIntValue("status");
        }
        return globalStatus | checkStatus;
    }

    static {
        componentCheckItems.add(new RedisCheckExecutor());
        componentCheckItems.add(new ZookeeperCheckExecutor());
        componentCheckItems.add(new DBCheckExecutor());
        try {
            ServiceLoader<HealthCheck> loader = ServiceLoader.load(HealthCheck.class);
            for (HealthCheck checker : loader) {
                componentCheckItems.add(checker);
            }
        }
        catch (Exception e) {
            SafeLogUtils.error(HealthCheckService.class, (String)"load service error", (Throwable)e);
        }
    }
}

