/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.healthcheck.spi.component;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import kd.bos.db.DBType;
import kd.bos.db.datasource.DataSourceURLs;
import kd.bos.encrypt.Encrypters;
import kd.bos.eye.api.healthcheck.spi.CheckResult;
import kd.bos.eye.api.healthcheck.spi.HealthCheck;
import kd.bos.eye.api.healthcheck.spi.component.ComponentCheckResult;
import kd.bos.ksql.DbType;
import kd.bos.ksql.shell.KDDriverUtil;

public class DBCheckExecutor
implements HealthCheck {
    @Override
    public List<CheckResult> check() {
        List<JSONObject> list = this.getDBConfig();
        int size = list.size();
        ArrayList<CheckResult> results = new ArrayList<CheckResult>(size);
        for (int i = 0; i < size; ++i) {
            JSONObject instance = list.get(i);
            Properties properties = new Properties();
            String dbInstance = instance.getString("dbinsatnce");
            String dbIp = instance.getString("dbip");
            int dbPort = instance.getIntValue("dbport");
            String dbUser = instance.getString("dbuser");
            Boolean isCluster = instance.getBoolean("isCluster");
            String tempStr = dbIp + ":" + dbPort + "/" + dbInstance + "$" + dbUser;
            try {
                long start;
                DBType dbType;
                block43: {
                    String url;
                    String dbTypeParam = instance.getString("dbtype");
                    dbType = this.getDBType(dbTypeParam);
                    if (isCluster.booleanValue()) {
                        String clusterDbUrl = instance.getString("dburl");
                        url = DataSourceURLs.genClusterUrl((DBType)dbType, (String)clusterDbUrl, (String)dbInstance);
                    } else {
                        url = DataSourceURLs.genURL((DBType)dbType, (String)dbIp, (int)dbPort, (String)dbInstance);
                    }
                    start = System.currentTimeMillis();
                    properties.setProperty("url", url);
                    properties.setProperty("password", Encrypters.decode((String)instance.getString("dbpassword")));
                    properties.setProperty("user", dbUser);
                    try (Connection connection = KDDriverUtil.connect((String)url, (Properties)properties);
                         PreparedStatement st = connection.prepareStatement("select 1");
                         ResultSet rs = st.executeQuery();){
                        if (!rs.next()) break block43;
                        rs.getString(1);
                    }
                    catch (Exception e) {
                        results.add(ComponentCheckResult.error(tempStr, "DB", "create connect or query db exception,message: " + e.getMessage()));
                        continue;
                    }
                }
                long eclipseTime = System.currentTimeMillis() - start;
                int level = HealthCheck.getLevel(eclipseTime);
                results.add(ComponentCheckResult.ofResult(tempStr, DbType.getName((int)dbType.getValue()), String.format("check cost time: %d ms", eclipseTime), level));
                continue;
            }
            catch (Exception e) {
                results.add(ComponentCheckResult.error(tempStr, "DB", "create connect or query db exception,message: " + e.getMessage()));
            }
        }
        return results;
    }

    private List<JSONObject> getDBConfig() {
        MyList list = new MyList();
        String ids = System.getProperty("mc.tenant.ids");
        JSONArray tenants = JSON.parseArray((String)ids);
        JSONArray ret = new JSONArray();
        int size = tenants.size();
        for (int i = 0; i < size; ++i) {
            JSONObject jsonObject = tenants.getJSONObject(i);
            String tenantNumber = jsonObject.getString("tenantnumber");
            String key = "mc.tenant." + tenantNumber.trim() + ".data";
            String property = System.getProperty(key);
            JSONArray array = JSON.parseArray((String)property);
            int size1 = array.size();
            for (int j = 0; j < size1; ++j) {
                JSONObject object = array.getJSONObject(j);
                ret.addAll((Collection)object.getJSONArray("instancelist"));
            }
        }
        int size1 = ret.size();
        for (int i = 0; i < size1; ++i) {
            JSONObject jsonObject = ret.getJSONObject(i);
            if (list.contains(jsonObject)) continue;
            list.add(jsonObject);
        }
        return list;
    }

    private DBType getDBType(String type) {
        switch (type) {
            case "0": {
                return DBType.Oracle;
            }
            case "2": {
                return DBType.MySQL;
            }
            case "1": {
                return DBType.PostgreSQL;
            }
            case "3": {
                return DBType.DM;
            }
            case "4": {
                return DBType.GS100;
            }
            case "5": {
                return DBType.GS;
            }
            case "6": {
                return DBType.SQLServer;
            }
        }
        throw new RuntimeException("illegal database type");
    }

    private static class MyList
    extends ArrayList<JSONObject> {
        private MyList() {
        }

        private boolean contains(JSONObject o) {
            for (int i = 0; i < this.size(); ++i) {
                boolean dbPassword;
                boolean dbUser;
                boolean dbInstance;
                boolean dbType;
                boolean dbPort;
                JSONObject object = (JSONObject)this.get(i);
                boolean dbIp = o.getString("dbip").equals(object.getString("dbip"));
                if (!dbIp || !(dbPort = o.getString("dbport").equals(object.getString("dbport"))) || !(dbType = o.getString("dbtype").equals(object.getString("dbtype"))) || !(dbInstance = o.getString("dbinsatnce").equals(object.getString("dbinsatnce"))) || !(dbUser = o.getString("dbuser").equals(object.getString("dbuser"))) || !(dbPassword = o.getString("dbpassword").equals(object.getString("dbpassword")))) continue;
                return true;
            }
            return false;
        }
    }
}

