/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.healthcheck.spi.service;

import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.RecursiveTask;
import kd.bos.eye.api.appinfo.EyeNodeInfo;
import kd.bos.eye.api.armor.Grocery;
import kd.bos.eye.api.healthcheck.spi.CheckResult;
import kd.bos.eye.api.healthcheck.spi.HealthCheck;
import kd.bos.eye.api.healthcheck.spi.service.ServiceCheckResult;
import kd.bos.instance.Instance;
import kd.bos.util.JSONUtils;
import kd.bos.util.StringUtils;

public class ServiceHealthCheckExecutor
implements HealthCheck {
    private static Class<?> clazz = null;
    private static Method canResponse = null;
    private static final String APP_NAME = Instance.getAppName();
    private static final String INSTANCE_ID = Instance.getInstanceId();
    private static final int CONNECT_TIMEOUT = Integer.getInteger("monitor.healthCheck.http.connect.timeout", 3000);
    private static final int REQUEST_TIMEOUT = Integer.getInteger("monitor.healthCheck.http.request.timeout", 3000);
    private JSONObject params;

    public ServiceHealthCheckExecutor(JSONObject params) {
        this.params = params;
    }

    @Override
    public List<CheckResult> check() {
        JSONObject param = this.params.getJSONObject("params");
        String specialId = param.getString("instanceId");
        if (StringUtils.isNotEmpty((String)specialId)) {
            return Collections.singletonList(ServiceHealthCheckExecutor.checkMyself());
        }
        String appNames = param.getString("appNames");
        ArrayList<EyeNodeInfo> allNodeInfo = Grocery.getAllNodeInfo();
        ArrayList<CheckResult> results = new ArrayList<CheckResult>(allNodeInfo.size());
        if (StringUtils.isEmpty((String)appNames)) {
            for (EyeNodeInfo nodeInfo : allNodeInfo) {
                if (nodeInfo.getInstanceId().equals(INSTANCE_ID)) {
                    results.add(ServiceHealthCheckExecutor.checkMyself());
                    continue;
                }
                param.put("instanceId", (Object)nodeInfo.getInstanceId());
                this.params.put("params", (Object)param);
                results.add(this.remoteCheck(nodeInfo));
            }
        } else {
            String[] appName = appNames.split(",");
            for (EyeNodeInfo nodeInfo : allNodeInfo) {
                String name = nodeInfo.getAppName();
                boolean contains = this.isContains(appName, name);
                if (!contains) continue;
                String instanceId = nodeInfo.getInstanceId();
                if (instanceId.equals(INSTANCE_ID)) {
                    results.add(ServiceHealthCheckExecutor.checkMyself());
                    continue;
                }
                param.put("instanceId", (Object)instanceId);
                this.params.put("params", (Object)param);
                results.add(this.remoteCheck(nodeInfo));
            }
        }
        return results;
    }

    private boolean isContains(String[] values, String value) {
        if (value != null && value.length() > 0 && values != null && values.length > 0) {
            String[] var2 = values;
            int var3 = values.length;
            for (int var4 = 0; var4 < var3; ++var4) {
                String v = var2[var4];
                if (!value.equals(v)) continue;
                return true;
            }
        }
        return false;
    }

    public static CheckResult checkMyself() {
        if (Instance.isPausedServiceByMonitor()) {
            return ServiceCheckResult.warn(APP_NAME, INSTANCE_ID, "service is paused");
        }
        return ServiceHealthCheckExecutor.canResponse();
    }

    private static CheckResult canResponse() {
        if (canResponse != null) {
            try {
                boolean result = (Boolean)canResponse.invoke(clazz, new Object[0]);
                return result ? ServiceCheckResult.success(APP_NAME, INSTANCE_ID) : ServiceCheckResult.error(APP_NAME, INSTANCE_ID, "service can not response");
            }
            catch (Exception e) {
                return ServiceCheckResult.error(APP_NAME, INSTANCE_ID, "service unavailable,cause by: " + e.getMessage());
            }
        }
        return ServiceCheckResult.warn(APP_NAME, INSTANCE_ID, "service unavailable,cause by: reflection failed");
    }

    private CheckResult remoteCheck(EyeNodeInfo nodeInfo) {
        try {
            String result = Grocery.httpPost(nodeInfo.getIp(), Integer.parseInt(nodeInfo.getMonitorPort()), this.params.toJSONString(), "monitor/healthcheck/v1", REQUEST_TIMEOUT, CONNECT_TIMEOUT);
            if (StringUtils.isEmpty((String)result)) {
                return ServiceCheckResult.error(nodeInfo.getAppName(), nodeInfo.getInstanceId(), "http post checkResult is empty");
            }
            return (CheckResult)JSONUtils.cast((String)result, ServiceCheckResult.class);
        }
        catch (IOException e) {
            return ServiceCheckResult.error(nodeInfo.getAppName(), nodeInfo.getInstanceId(), "http post checkResult error, cause by: " + e.getMessage());
        }
    }

    static {
        try {
            clazz = Class.forName("kd.bos.mservice.monitor.MserviceStatusManger");
            canResponse = clazz.getDeclaredMethod("canResponse", new Class[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private class CheckTask
    extends RecursiveTask<List<CheckResult>> {
        private int start;
        private int end;
        private List<EyeNodeInfo> list;

        public CheckTask(int start, int end, List<EyeNodeInfo> list) {
            this.start = start;
            this.end = end;
            this.list = list;
        }

        public List<CheckResult> runTask(List<EyeNodeInfo> list) {
            ArrayList<CheckResult> objects = new ArrayList<CheckResult>(list.size());
            for (EyeNodeInfo nodeInfo : list) {
                try {
                    String result = Grocery.httpPost(nodeInfo.getIp(), Integer.parseInt(nodeInfo.getMonitorPort()), ServiceHealthCheckExecutor.this.params.toJSONString(), "monitor/eye/healthCheck", REQUEST_TIMEOUT, CONNECT_TIMEOUT);
                    if (StringUtils.isEmpty((String)result)) {
                        objects.add(ServiceCheckResult.error(nodeInfo.getAppName(), nodeInfo.getInstanceId(), "http post checkResult is empty"));
                        continue;
                    }
                    objects.add(ServiceCheckResult.success(nodeInfo.getAppName(), nodeInfo.getInstanceId()));
                }
                catch (IOException e) {
                    objects.add(ServiceCheckResult.error(nodeInfo.getAppName(), nodeInfo.getInstanceId(), "http post checkResult error, cause by: " + e.getMessage()));
                }
            }
            return objects;
        }

        @Override
        protected List<CheckResult> compute() {
            if (this.end - this.start <= 4) {
                return this.runTask(this.list);
            }
            int middle = (this.start + this.end) / 2;
            CheckTask left = new CheckTask(this.start, middle, this.list);
            CheckTask right = new CheckTask(middle, this.end, this.list);
            left.fork();
            right.fork();
            List join = (List)left.join();
            List join1 = (List)right.join();
            join.addAll(join1);
            return join;
        }
    }
}

