/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.home;

import com.sun.net.httpserver.HttpExchange;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.eye.httpserver.AbstractHttpHandler;
import kd.bos.eye.util.ApiResponse;
import kd.bos.govern.StorageType;
import kd.bos.government.storage.Storage;
import kd.bos.government.storage.StorageFactory;
import kd.bos.util.JSONUtils;

public class ServiceInstTopologyHandler
extends AbstractHttpHandler {
    private static final StorageType storageType = StorageType.getStorageType((String)System.getProperty("apm.gov.invoke.report.storage.type", "elasticsearch"));
    private static final Storage storage = StorageFactory.getStorage((StorageType)storageType);

    @Override
    protected void handle0(HttpExchange exchange) throws IOException {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        ApiResponse<List> response = new ApiResponse<List>();
        try {
            Map<String, String> params = this.getParams(exchange, false);
            String start = params.get("start");
            String end = params.get("end");
            String instance = params.get("instance");
            List list = storage.queryServiceInstTopology(dateFormat.parse(start), end != null ? dateFormat.parse(end) : new Date(), instance);
            response.setCode(0);
            response.setData(list);
        }
        catch (ParseException e) {
            response.setCode(-1);
            response.setMsg("query topology error,error message:" + e.getMessage());
        }
        this.writeJson(JSONUtils.toString(response), exchange);
    }
}

