/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.home;

import com.alibaba.fastjson.JSONObject;
import com.sun.net.httpserver.HttpExchange;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.eye.api.config.manager.UnifiedConfigHookService;
import kd.bos.eye.api.config.manager.UnifiedConfigManager;
import kd.bos.eye.api.oplog.OpLogManager;
import kd.bos.eye.api.oplog.OpLogger;
import kd.bos.eye.config.custom.ConfigDbHelper;
import kd.bos.eye.config.custom.ConfigModule;
import kd.bos.eye.httpserver.AbstractHttpHandler;
import kd.bos.eye.util.ApiResponse;
import kd.bos.eye.util.ExceptionHandler;
import kd.bos.eye.util.ExchangeVueUtils;
import kd.bos.govern.GovernConfigs;
import kd.bos.govern.StorageType;
import kd.bos.government.storage.Storage;
import kd.bos.government.storage.StorageFactory;
import kd.bos.mservice.monitor.lang.LangRes;
import kd.bos.util.JSONUtils;
import kd.bos.util.StringUtils;

public class TopoHandler
extends AbstractHttpHandler {
    private static final String SERVICE_INSTANCES_TOPO = "mserviceInstTopo";
    private static final String TOPO_LEVEL_ONE = "1";
    private static final StorageType storageType = StorageType.getStorageType((String)System.getProperty("apm.gov.invoke.report.storage.type", StorageType.ELASTICSEARCH.value()));
    private static final Storage storage = StorageFactory.getStorage((StorageType)storageType);
    private static final OpLogger OPLOGGER = OpLogManager.getLogger();

    @Override
    protected void handle0(HttpExchange exchange) throws IOException {
        ApiResponse response = new ApiResponse();
        try {
            if (!GovernConfigs.getTopologyEnable()) {
                HashMap<String, String> retMap = new HashMap<String, String>(8);
                response.setCode(0);
                retMap.put("enable", "false");
                retMap.put("key", "gov.topology.enable");
                response.setData(retMap);
                this.writeJson(JSONUtils.toString(response), exchange);
                return;
            }
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Map<String, String> params = ExchangeVueUtils.parseParameters(exchange);
            String start = params.get("start");
            String end = params.get("end");
            String source = params.get("source");
            String target = params.get("target");
            String type = params.get("type");
            String minDuration = params.getOrDefault("minDuration", TOPO_LEVEL_ONE);
            String mserviceInstTopo = params.get(SERVICE_INSTANCES_TOPO);
            JSONObject data = new JSONObject();
            if (StringUtils.isEmpty((String)type)) {
                if (StringUtils.isEmpty((String)mserviceInstTopo)) {
                    data = storage.queryTopo(dateFormat.parse(start), end != null ? dateFormat.parse(end) : new Date(), source, target, minDuration);
                } else if (TOPO_LEVEL_ONE.equals(mserviceInstTopo)) {
                    data = storage.queryTopoServiceInstances(dateFormat.parse(start), end != null ? dateFormat.parse(end) : new Date(), source, target, minDuration);
                }
            } else {
                data = storage.queryComponentTopo(dateFormat.parse(start), end != null ? dateFormat.parse(end) : new Date(), source, target, type);
            }
            data.put("threshold_yellow", (Object)ConfigDbHelper.getValueByKey("monitor.topo.threshold.normal", "5"));
            data.put("threshold_red", (Object)ConfigDbHelper.getValueByKey("monitor.topo.threshold.slow", "10"));
            response.setData(data);
        }
        catch (Exception e) {
            response.setCode(-1);
            response.setMsg(ExceptionHandler.getExceptionStackTrace(e));
        }
        this.writeJson(JSONUtils.toString(response), exchange);
    }

    public static class TopoAnalysisConfigHook
    implements UnifiedConfigHookService {
        public static void registerHook() {
            TopoAnalysisConfigHook hook = new TopoAnalysisConfigHook();
            UnifiedConfigManager.registHookService(ConfigModule.TOPOLOGY_CONFIG.getNumber(), "monitor.topo.threshold.normal", hook);
            UnifiedConfigManager.registHookService(ConfigModule.TOPOLOGY_CONFIG.getNumber(), "monitor.topo.threshold.slow", hook);
        }

        @Override
        public String beforeSave(String key, UnifiedConfigManager.ConfigParam configParam) throws Exception {
            String value = configParam.getValue();
            int cfgSlowValue = 0;
            int cfgNormalValue = 0;
            if (key.equals("monitor.topo.threshold.normal")) {
                cfgSlowValue = Integer.parseInt(ConfigDbHelper.getValueByKey("monitor.topo.threshold.slow"));
                if (StringUtils.isNumericString((String)value) && (cfgNormalValue = Integer.parseInt(value)) > 0 && cfgSlowValue - cfgNormalValue >= 1) {
                    return "";
                }
                return LangRes.get((String)"TopoHandler_0", (String)"\u8bf7\u8f93\u5165\u5927\u4e8e0\u4e14\u5c0f\u4e8e{0}\u6570\u5b57", (Object[])new Object[]{cfgSlowValue});
            }
            if (key.equals("monitor.topo.threshold.slow")) {
                cfgNormalValue = Integer.parseInt(ConfigDbHelper.getValueByKey("monitor.topo.threshold.normal"));
                if (StringUtils.isNumericString((String)value) && (cfgSlowValue = Integer.parseInt(value)) > 0 && cfgSlowValue - cfgNormalValue >= 1 && cfgSlowValue <= 10) {
                    return "";
                }
                return LangRes.get((String)"TopoHandler_1", (String)"\u8bf7\u8f93\u5165\u5927\u4e8e{0}\u4e14\u5c0f\u4e8e\u7b49\u4e8e10\u7684\u6570\u5b57", (Object[])new Object[]{cfgNormalValue});
            }
            return "";
        }

        @Override
        public void afterSave(String key, UnifiedConfigManager.ConfigParam configParam) throws Exception {
        }
    }
}

