/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.home;

import com.alibaba.fastjson.JSONObject;
import com.sun.net.httpserver.HttpExchange;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.eye.api.home.TopoHandler;
import kd.bos.eye.api.oplog.OpLogManager;
import kd.bos.eye.api.oplog.OpLogger;
import kd.bos.eye.util.ApiResponse;
import kd.bos.eye.util.ExceptionHandler;
import kd.bos.eye.util.ExchangeVueUtils;
import kd.bos.govern.GovernConfigs;
import kd.bos.govern.StorageType;
import kd.bos.government.storage.Storage;
import kd.bos.government.storage.StorageFactory;
import kd.bos.mservice.monitor.lang.LangRes;
import kd.bos.util.JSONUtils;

public class TopoInvokeDetailHandler
extends TopoHandler {
    private static final StorageType storageType = StorageType.getStorageType((String)System.getProperty("apm.gov.invoke.report.storage.type", StorageType.ELASTICSEARCH.value()));
    private static final Storage storage = StorageFactory.getStorage((StorageType)storageType);
    private static final OpLogger OPLOGGER = OpLogManager.getLogger();

    @Override
    protected void handle0(HttpExchange exchange) throws IOException {
        ApiResponse<Object> response = new ApiResponse<Object>();
        try {
            if (!GovernConfigs.getApicallEnable()) {
                HashMap<String, String> retMap = new HashMap<String, String>(8);
                response.setCode(0);
                retMap.put("enable", "false");
                retMap.put("key", "gov.apicall.enable");
                response.setMsg(LangRes.get((String)"TopoInvokeDetailHandler_0", (String)"Topological call details rely on API monitoring. Please enable API monitoring in system configuration -> feature toggle", (Object[])new Object[0]));
                response.setData(retMap);
                this.writeJson(JSONUtils.toString(response), exchange);
                return;
            }
            Map<String, String> params = ExchangeVueUtils.parseParameters(exchange);
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String start = params.get("start");
            String end = params.get("end");
            String source = params.get("source");
            String target = params.get("target");
            String orderType = params.get("orderType");
            int topLine = Integer.parseInt(params.get("topLine"));
            int usedTime = Integer.parseInt(params.get("usedTime")) * 1000;
            String rangeOrder = params.get("rangeOrder");
            JSONObject apiInvoker = storage.queryInvokeDetail(dateFormat.parse(start), end != null ? dateFormat.parse(end) : new Date(), source, target, orderType, topLine, usedTime, rangeOrder);
            response.setData(apiInvoker.get((Object)"data"));
            response.setCode(0);
        }
        catch (Exception e) {
            response.setCode(-1);
            response.setMsg(ExceptionHandler.getExceptionStackTrace(e));
        }
        this.writeJson(JSONUtils.toString(response), exchange);
    }
}

