/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.home;

import com.alibaba.fastjson.JSONObject;
import com.sun.net.httpserver.HttpExchange;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.eye.auth.SessionStore;
import kd.bos.eye.httpserver.AbstractHttpHandler;
import kd.bos.eye.util.ApiResponse;
import kd.bos.govern.GovernConfigs;
import kd.bos.govern.StorageType;
import kd.bos.government.storage.Storage;
import kd.bos.government.storage.StorageFactory;
import kd.bos.util.JSONUtils;

public class TopologyHandler
extends AbstractHttpHandler {
    private static final StorageType storageType = StorageType.getStorageType((String)System.getProperty("apm.gov.invoke.report.storage.type", "elasticsearch"));
    private static final Storage storage = StorageFactory.getStorage((StorageType)storageType);

    @Override
    protected void handle0(HttpExchange exchange) throws IOException {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        ApiResponse response = new ApiResponse();
        HashMap<String, Object> retMap = new HashMap<String, Object>(8);
        String token = TopologyHandler.getToken(exchange);
        Map<String, String> userInfo = SessionStore.get().get(token);
        if (!GovernConfigs.getTopologyEnable()) {
            response.setCode(0);
            retMap.put("isFirstLogin", userInfo.get("isFirstLogin"));
            retMap.put("isExpirePassword", userInfo.get("isExpired"));
            retMap.put("enable", "false");
            retMap.put("key", "gov.topology.enable");
            response.setData(retMap);
            this.writeJson(JSONUtils.toString(response), exchange);
            return;
        }
        try {
            Map<String, String> params = this.getParams(exchange, false);
            String start = params.get("start");
            String end = params.get("end");
            String instance = params.get("instance");
            ArrayList<Map> rootNode = new ArrayList<Map>(16);
            ArrayList<Map<String, Object>> childrenNode = new ArrayList<Map<String, Object>>(16);
            int id = 0;
            List list = storage.queryTopology(dateFormat.parse(start), end != null ? dateFormat.parse(end) : new Date(), instance);
            HashMap costMap = new HashMap(32);
            ArrayList serviceInstance = new ArrayList(16);
            for (Map objectMap : list) {
                objectMap.put("id", id++);
                rootNode.add(objectMap);
                List childrens = (List)objectMap.get("children");
                ArrayList<Object> ids = new ArrayList<Object>(32);
                String name = (String)objectMap.get("name");
                HashMap<String, String> instanceMap = new HashMap<String, String>(2);
                instanceMap.put("label", name);
                instanceMap.put("value", name);
                serviceInstance.add(instanceMap);
                for (Map children : childrens) {
                    String cname = (String)children.get("name");
                    boolean needSplit = cname.contains("?");
                    String reName = cname;
                    if (needSplit) {
                        reName = cname.split("\\?")[0];
                    }
                    if (!children.get("type").equals("cloud")) {
                        reName = reName.replace(reName.substring(0, reName.indexOf(":") + 1), "");
                        reName = reName.replace("/", "");
                        reName = reName.replace("sentinel:", "");
                        reName = reName.replace(";", "");
                        reName = reName.replace(",", "");
                    }
                    costMap.put(name + reName, children.get("cost"));
                    Object tempId = this.getId(childrenNode, children);
                    if (tempId != null) {
                        if (!ids.contains(tempId)) {
                            ids.add(tempId);
                        }
                    } else {
                        ids.add(id);
                        children.put("id", id++);
                        childrenNode.add(children);
                    }
                    if (!needSplit) continue;
                    children.put("name", reName);
                }
                objectMap.put("childrenIds", ids);
            }
            this.formatChildren(childrenNode);
            retMap.put("rootNode", rootNode);
            retMap.put("childrenNode", childrenNode);
            retMap.put("nodeCost", costMap);
            retMap.put("serviceInstance", serviceInstance);
            retMap.put("instance", instance);
            retMap.put("isFirstLogin", userInfo.get("isFirstLogin"));
            retMap.put("isExpirePassword", userInfo.get("isExpired"));
            response.setCode(0);
            response.setData(retMap);
        }
        catch (ParseException e) {
            response.setCode(-1);
            response.setMsg("query topology error,error message:" + e.getMessage());
        }
        this.writeJson(JSONUtils.toString(response), exchange);
    }

    private void cost(Map<String, Object> costMap, List<Map<String, Object>> childrens, String name, List<Map<String, Object>> childrenNode, List<Object> ids, int id) {
        for (Map<String, Object> children : childrens) {
            costMap.put(name + children.get("name"), children.get("cost"));
            Object tempId = this.getId(childrenNode, children);
            if (tempId != null) {
                if (ids.contains(tempId)) continue;
                ids.add(tempId);
                continue;
            }
            ids.add(id);
            children.put("id", id++);
            childrenNode.add(children);
        }
    }

    private Object getId(List<Map<String, Object>> nodes, Map<String, Object> node) {
        String tempName = (String)node.get("name");
        String tempType = (String)node.get("type");
        for (Map<String, Object> map : nodes) {
            String name = (String)map.get("name");
            String type = (String)map.get("type");
            if (!name.equals(tempName) || !tempType.equals(type) || "MService".equals(type)) continue;
            return map.get("id");
        }
        return null;
    }

    private JSONObject onlyTest() {
        StringBuilder sb = new StringBuilder();
        try (InputStream resourceAsStream2 = Thread.currentThread().getContextClassLoader().getResourceAsStream("data.json");
             InputStreamReader inputStreamReader = new InputStreamReader(resourceAsStream2);
             BufferedReader reader = new BufferedReader(inputStreamReader);){
            String line = null;
            while ((line = reader.readLine()) != null) {
                sb.append(line);
            }
        }
        catch (Exception resourceAsStream2) {
            // empty catch block
        }
        JSONObject jsonObject = JSONObject.parseObject((String)sb.toString());
        return jsonObject.getJSONObject("data");
    }

    private void formatChildren(List<Map<String, Object>> childrenNode) {
        for (Map<String, Object> children : childrenNode) {
            if ("cloud".equals(children.get("type"))) continue;
            String newName = this.formatName((String)children.get("name"));
            children.put("name", newName);
            children.put("label", newName.replaceAll("\\\\n", ""));
        }
    }

    private String formatName(String name) {
        String temp;
        String nameWithHead = name.toLowerCase(Locale.ENGLISH).startsWith("redis") ? (Character.isDigit((temp = name.substring(name.split(":")[0].length() + 1)).charAt(0)) ? temp : temp.substring(temp.split(":")[0].length() + 1)) : name.substring(name.split(":")[0].length() + 1);
        if (nameWithHead.contains("?")) {
            nameWithHead = nameWithHead.split("\\?")[0];
        }
        if (nameWithHead.contains("/")) {
            String[] arr = nameWithHead.split("/");
            nameWithHead = arr[arr.length - 1];
        }
        nameWithHead = nameWithHead.replaceAll("[,|;]", "\n");
        return nameWithHead;
    }
}

