/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.jmx.chart;

import com.sun.net.httpserver.HttpExchange;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import kd.bos.eye.httpserver.AbstractHttpHandler;
import kd.bos.eye.util.TemplateUtil;
import kd.bos.util.WebPortUtil;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class ConnectPoolChartJsonHandler
extends AbstractHttpHandler {
    private static final String REDIS = "redis:";
    private static final String SENTINEL = "sentinel:";
    private static final String CLUSTER = "cluster:";
    private static final String SHARD = "shard:";

    @Override
    public void handle0(HttpExchange pExchange) throws IOException {
        byte[] response = this.getJson();
        pExchange.getResponseHeaders().set("Content-Type", "application/json; charset=UTF-8");
        pExchange.sendResponseHeaders(202, response.length);
        pExchange.getResponseBody().write(response);
        pExchange.close();
    }

    private byte[] getJson() throws IOException {
        String json = TemplateUtil.loadTemplate("/jmx/connectpoolchartconfig.json");
        String redisjson = this.appendRedisJson();
        json = redisjson.length() > 0 ? json.replaceAll("\\{redis\\}", "," + redisjson) : json.replaceAll("\\{redis\\}", "");
        if (WebPortUtil.isWebNode()) {
            json = json.replaceAll("\\{dubbo\\}", "");
            json = json.replaceAll("\\{jetty\\}", "," + this.appendJettyJson());
        } else {
            json = json.replaceAll("\\{dubbo\\}", "," + this.appendDubboJson());
            json = json.replaceAll("\\{jetty\\}", "");
        }
        try {
            new JSONParser().parse(json);
            return json.getBytes("UTF-8");
        }
        catch (ParseException e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    private String appendDubboJson() {
        String dubbojson = TemplateUtil.loadTemplate("/jmx/dubbochart.json");
        return dubbojson;
    }

    private String appendJettyJson() {
        String dubbojson = TemplateUtil.loadTemplate("/jmx/jettychart.json");
        return dubbojson;
    }

    private String appendRedisJson() {
        String redisjson = TemplateUtil.loadTemplate("/jmx/redischart.json");
        String url = System.getProperty("redis.serversForCache");
        StringBuilder builder = new StringBuilder();
        if (url.startsWith(REDIS)) {
            url = url.substring(REDIS.length());
            url = url.replaceAll(":", "-");
            builder.append(redisjson.replaceAll("\\{url\\}", url));
        } else if (url.startsWith(SENTINEL)) {
            url = url.substring(SENTINEL.length());
            url = url.replaceAll(":", "-");
            builder.append(redisjson.replaceAll("\\{url\\}", url));
        } else if (url.startsWith(CLUSTER)) {
            url = url.substring(CLUSTER.length());
            List<String> urls = this.parseClusterServer(url);
            urls.forEach(x -> {
                if (builder.length() > 0) {
                    builder.append(',');
                }
                builder.append(redisjson.replaceAll("\\{url\\}", (String)x));
            });
        } else if (url.startsWith(SHARD)) {
            url = url.substring(SHARD.length());
            url = url.replaceAll(":", "-");
            builder.append(redisjson.replaceAll("\\{url\\}", url));
        }
        String url2 = System.getProperty("redis.serversForSession");
        if (url2.startsWith(REDIS)) {
            url2 = url2.substring(REDIS.length());
            if (!url.equals(url2 = url2.replaceAll(":", "-"))) {
                if (builder.length() > 0) {
                    builder.append(',');
                }
                builder.append(redisjson.replaceAll("\\{url\\}", url2));
            }
        } else if (url2.startsWith(SENTINEL)) {
            url2 = url2.substring(SENTINEL.length());
            if (!url.equals(url2 = url2.replaceAll(":", "-"))) {
                if (builder.length() > 0) {
                    builder.append(',');
                }
                builder.append(redisjson.replaceAll("\\{url\\}", url2));
            }
        } else if (url2.startsWith(CLUSTER)) {
            if (!url.equals(url2 = url2.substring(CLUSTER.length()))) {
                List<String> urls = this.parseClusterServer(url2);
                urls.forEach(x -> {
                    if (builder.length() > 0) {
                        builder.append(',');
                    }
                    builder.append(redisjson.replaceAll("\\{url\\}", (String)x));
                });
            }
        } else if (url2.startsWith(SHARD) && !url.equals(url2 = url2.substring(SHARD.length()))) {
            if (builder.length() > 0) {
                builder.append(',');
            }
            builder.append(redisjson.replaceAll("\\{url\\}", url2));
        }
        return builder.toString();
    }

    private List<String> parseClusterServer(String server) {
        String[] parts = server.split("/");
        if (parts.length == 2) {
            server = parts[0];
        }
        ArrayList<String> hosts = new ArrayList<String>();
        parts = server.split(";|,");
        for (int i = 0; i < parts.length; ++i) {
            String[] hap = parts[i].split(":");
            if (hap.length != 2) continue;
            hosts.add(hap[0] + "-" + hap[1]);
        }
        return hosts;
    }
}

