/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.log;

import com.alibaba.fastjson.JSONObject;
import com.sun.net.httpserver.HttpExchange;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.eye.api.oplog.OpLogManager;
import kd.bos.eye.api.oplog.OpLogger;
import kd.bos.eye.httpserver.AbstractHttpHandler;
import kd.bos.eye.util.ExchangeVueUtils;
import kd.bos.govern.StorageType;
import kd.bos.government.storage.Storage;
import kd.bos.government.storage.StorageFactory;
import kd.bos.mservice.ServiceInfoFactory;
import kd.bos.mservice.monitor.ServiceInfo;
import kd.bos.util.JSONUtils;

public class LogDiscardCountHandler
extends AbstractHttpHandler {
    private static final StorageType STORAGE_TYPE = StorageType.getStorageType((String)System.getProperty("apm.gov.invoke.report.storage.type", StorageType.ELASTICSEARCH.value()));
    private static final Storage STORAGE = StorageFactory.getStorage((StorageType)STORAGE_TYPE);
    private static final OpLogger OPLOGGER = OpLogManager.getLogger();

    @Override
    public void handle0(HttpExchange exchange) throws IOException {
        Map params = ExchangeVueUtils.parseJsonFromPost(exchange, Map.class);
        HashMap<String, Object> response = new HashMap<String, Object>(8);
        try {
            HashMap<String, List<Map<String, String>>> data = new HashMap<String, List<Map<String, String>>>();
            Boolean isInit = (Boolean)params.get("init");
            List serviceList = ServiceInfoFactory.get().getServiceList();
            List<Map<String, String>> instanceList = this.getInstanceList(serviceList);
            data.put("instanceList", instanceList);
            if (!isInit.booleanValue()) {
                JSONObject jsonObject = STORAGE.queryMetrics(params);
                jsonObject.remove((Object)"instanceList");
                data.put("metricsData", (List<Map<String, String>>)jsonObject);
            }
            response.put("code", 0);
            response.put("msg", "success");
            response.put("data", data);
        }
        catch (Exception e) {
            response.put("code", -1);
            response.put("msg", "get discard count is failed. ERROR_INFO: " + e.getMessage());
        }
        String str = JSONUtils.toString(response);
        this.writeJson(str, exchange);
    }

    private List<Map<String, String>> getInstanceList(List<ServiceInfo> serviceList) {
        ArrayList<Map<String, String>> instanceList = new ArrayList<Map<String, String>>(10);
        for (ServiceInfo serviceInfo : serviceList) {
            HashMap<String, String> instance = new HashMap<String, String>(4);
            instance.put("appName", serviceInfo.getAppName());
            instance.put("ip", serviceInfo.getIp());
            instance.put("id", serviceInfo.getAppName() + "\n" + serviceInfo.getIp());
            instanceList.add(instance);
        }
        return instanceList;
    }
}

