/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.log;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.text.SimpleDateFormat;
import java.util.TimeZone;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import kd.bos.encrypt.Encrypters;
import kd.bos.eye.api.log.KDException;
import kd.bos.eye.api.log.datasource.LogDataSourceInfo;
import kd.bos.eye.api.log.datasource.LogDataSourceManager;
import kd.bos.util.StringUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.GzipDecompressingEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.Lookup;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.BasicHttpClientConnectionManager;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.util.Asserts;
import org.apache.http.util.EntityUtils;

@Deprecated
public class QueryResultBuilder {
    private static final String ES_USERNAME = "monitor.es.user";
    private static final String ES_PD = "monitor.es.password";
    private static final String ES_SSL_ENABLE = "monitor.es.ssl.enable";
    private static final String ES_CERTIFICATE_PATH = "monitor.es.certificate.path";
    private static final String ES_CERTIFICATE_PD = "monitor.es.certificate.password";
    private static final String ES_HTTP_CONNECTION_TIMEOUT = "monitor.es.connection.timeout";
    private static final String ES_HTTP_SOCKET_CONNECTION_TIMEOUT = "monitor.es.socket.connection.timeout";
    private static final String HTTPS_SCHEMA = "https";
    private static final String HTTP_SCHEMA = "http";
    private static KeyStore trustStore;
    private String url;
    private String params;
    private String logDataSource;

    private QueryResultBuilder() {
    }

    public static QueryResultBuilder build() {
        return new QueryResultBuilder();
    }

    public QueryResultBuilder url(String url) {
        this.url = url;
        return this;
    }

    public QueryResultBuilder params(String params) {
        this.params = params;
        return this;
    }

    public QueryResultBuilder logDataSource(String logDataSourceNumber) {
        this.logDataSource = logDataSourceNumber;
        return this;
    }

    public JSONArray builder() throws IOException {
        Asserts.notEmpty((CharSequence)this.url, (String)"elasticsearch url");
        Asserts.notEmpty((CharSequence)this.params, (String)"params");
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        JSONObject resource = this.httpClientPost(this.url, this.params);
        JSONArray ret = new JSONArray();
        JSONArray arrays = resource.getJSONObject("hits").getJSONArray("hits");
        int size = arrays.size();
        for (int i = 0; i < size; ++i) {
            try {
                JSONObject hit = arrays.getJSONObject(i);
                JSONObject source = hit.getJSONObject("_source");
                JSONObject logtags = source.getJSONObject("logtags");
                if (logtags == null) {
                    source.put("logtags", (Object)"");
                }
                String message = source.getString("message");
                String message2 = source.getString("message2");
                if (!StringUtils.isEmpty((String)message)) {
                    source.put("message", (Object)this.cleanXss(message));
                }
                if (!StringUtils.isEmpty((String)message2)) {
                    source.put("message2", (Object)this.cleanXss(message2));
                }
                source.put("time", (Object)dateFormat.format(simpleDateFormat.parse(source.getString("time"))));
                ret.add((Object)source);
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return ret;
    }

    private String cleanXss(String message) {
        if (!StringUtils.isEmpty((String)message)) {
            message = message.replaceAll("'", "&#39;");
            message = message.replaceAll("<", "&lt;");
            message = message.replaceAll(">", "&gt;");
            message = message.replaceAll("\"", "&quot;");
            message = message.replaceAll("'", "&#x27;");
            message = message.replaceAll("/", "&#x2f;");
        }
        return message;
    }

    private JSONObject httpClientPost(String url, String json) throws IOException {
        HttpClient client = this.createHttpClient();
        HttpPost post = new HttpPost(url);
        try {
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(Integer.parseInt(System.getProperty(ES_HTTP_CONNECTION_TIMEOUT, "300000"))).setSocketTimeout(Integer.parseInt(System.getProperty(ES_HTTP_SOCKET_CONNECTION_TIMEOUT, "300000"))).build();
            post.setConfig(requestConfig);
            StringEntity se = new StringEntity(json, ContentType.APPLICATION_JSON);
            post.setEntity((HttpEntity)se);
            HttpResponse response = client.execute((HttpUriRequest)post);
            if (response.getStatusLine().getStatusCode() == 200) {
                HttpEntity resEntity = response.getEntity();
                JSONObject jSONObject = JSONObject.parseObject((String)this.asJson(resEntity));
                return jSONObject;
            }
            StringBuilder sb = new StringBuilder("Can't access elastic, status:");
            sb.append(response.getStatusLine()).append(", detail:").append(response);
            throw new IOException(sb.toString());
        }
        finally {
            post.releaseConnection();
            if (client instanceof CloseableHttpClient) {
                ((CloseableHttpClient)client).close();
            }
        }
    }

    private HttpClient createHttpClient() {
        CloseableHttpClient client;
        LogDataSourceInfo logDataSourceInfo = LogDataSourceManager.getDataSourceByNumber(this.logDataSource);
        String username = logDataSourceInfo.getUs();
        String password = logDataSourceInfo.getPp();
        Boolean isSslEnable = logDataSourceInfo.isSslEnable();
        if (username != null && password != null) {
            password = Encrypters.decode((String)password);
            client = isSslEnable.booleanValue() ? this.createHttpsClient(username, password) : HttpClients.custom().setDefaultCredentialsProvider(this.initCreadentials(username, password)).build();
        } else {
            client = HttpClients.createDefault();
        }
        return client;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private CloseableHttpClient createHttpsClient(String username, String password) {
        Asserts.notNull((Object)trustStore, (String)"trustStore");
        LogDataSourceInfo logDataSourceInfo = LogDataSourceManager.getDataSourceByNumber(this.logDataSource);
        String path = logDataSourceInfo.getCertificatePath();
        if (path == null) {
            throw new KDException("Certificate cann't be null when use SSL/TLS, please config: monitor.es.certificate.path");
        }
        String certificatePwd = logDataSourceInfo.getCertificatePP();
        if (certificatePwd == null) {
            throw new KDException("Certificate password cann't be null when use SSL/TLS, please config: monitor.es.certificate.password");
        }
        try (FileInputStream is = new FileInputStream(FilenameUtils.normalize((String)path));){
            trustStore.load(is, certificatePwd.toCharArray());
            SSLContext sslContext = SSLContexts.custom().loadTrustMaterial(trustStore, null).build();
            SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
            Registry socketFactoryRegistry = RegistryBuilder.create().register(HTTPS_SCHEMA, (Object)sslsf).register(HTTP_SCHEMA, (Object)new PlainConnectionSocketFactory()).build();
            BasicHttpClientConnectionManager connectionManager = new BasicHttpClientConnectionManager((Lookup)socketFactoryRegistry);
            CloseableHttpClient closeableHttpClient = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf).setDefaultCredentialsProvider(this.initCreadentials(username, password)).setConnectionManager((HttpClientConnectionManager)connectionManager).build();
            return closeableHttpClient;
        }
        catch (Exception e) {
            throw new KDException(e);
        }
    }

    private String asJson(HttpEntity resEntity) throws IOException {
        Header respHeader = resEntity.getContentEncoding();
        if (respHeader != null && ("gzip".equalsIgnoreCase(respHeader.getValue()) || "x-gzip".equalsIgnoreCase(respHeader.getValue()))) {
            GzipDecompressingEntity gzipEntity = new GzipDecompressingEntity(resEntity);
            StringBuilder sb = new StringBuilder();
            try (InputStream in = gzipEntity.getContent();
                 InputStreamReader its = new InputStreamReader(in);
                 BufferedReader br = new BufferedReader(its);){
                String line;
                while ((line = br.readLine()) != null) {
                    sb.append(line);
                }
            }
            return sb.toString();
        }
        return EntityUtils.toString((HttpEntity)resEntity);
    }

    private CredentialsProvider initCreadentials(String username, String password) {
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(username, password));
        return credentialsProvider;
    }

    static {
        try {
            trustStore = KeyStore.getInstance("jks");
        }
        catch (KeyStoreException e) {
            trustStore = null;
        }
    }
}

