/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.log;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import java.util.TreeSet;
import kd.bos.eye.api.log.LogQueryRequest;
import kd.bos.eye.api.log.datasource.LogDataSourceManager;
import kd.bos.instance.Instance;
import kd.bos.util.StringUtils;

@Deprecated
public class QueryUrlBuilder {
    private static final String INDEX_PRE = Instance.getClusterName() + "-log-";
    public static final String INDEX_SUFFIX = "-";
    private LogQueryRequest queryRequest;

    private QueryUrlBuilder(LogQueryRequest queryRequest) {
        this.queryRequest = queryRequest;
    }

    public static QueryUrlBuilder build(LogQueryRequest queryRequest) {
        return new QueryUrlBuilder(queryRequest);
    }

    public String builder() {
        String URL2 = LogDataSourceManager.getDataSourceByNumber(this.queryRequest.getDatasource()).getUrl();
        if (StringUtils.isEmpty((String)URL2)) {
            throw new NullPointerException("monitor url is null");
        }
        if (!URL2.endsWith("/")) {
            URL2 = URL2 + "/";
        }
        return URL2 + this.getIndices() + "/_search?ignore_unavailable=true&allow_no_indices=true";
    }

    private String getIndices() {
        CharSequence[] indices;
        SimpleDateFormat sdfUTC = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        sdfUTC.setTimeZone(TimeZone.getTimeZone("UTC"));
        List<String> time = this.queryRequest.getTime();
        int max_range = Integer.getInteger("monitor.log.maxSearchRange", 5);
        TreeSet<String> betweenTime = new TreeSet<String>();
        SimpleDateFormat outFormat = new SimpleDateFormat("yyyy-MM-dd");
        try {
            int i;
            Date startTime = sdfUTC.parse(time.get(0));
            Date endTime = sdfUTC.parse(time.get(1));
            Calendar sCalendar = Calendar.getInstance();
            sCalendar.setTime(startTime);
            int year = sCalendar.get(1);
            int month = sCalendar.get(2);
            int day = sCalendar.get(5);
            sCalendar.set(year, month, day, 0, 0, 0);
            Calendar eCalendar = Calendar.getInstance();
            eCalendar.setTime(endTime);
            year = eCalendar.get(1);
            month = eCalendar.get(2);
            day = eCalendar.get(5);
            eCalendar.set(year, month, day, 0, 0, 0);
            String index = LogDataSourceManager.getDataSourceByNumber(this.queryRequest.getDatasource()).getIndex();
            String[] split = index.trim().split(",");
            int n = split.length;
            for (i = 0; i < n; ++i) {
                if (split[i].endsWith(INDEX_SUFFIX)) continue;
                int n2 = i;
                split[n2] = split[n2] + INDEX_SUFFIX;
            }
            while (sCalendar.before(eCalendar)) {
                n = split.length;
                for (i = 0; i < n; ++i) {
                    betweenTime.add(split[i] + outFormat.format(sCalendar.getTime()));
                }
                sCalendar.add(6, 1);
            }
            for (String pre : split) {
                betweenTime.add(pre + outFormat.format(eCalendar.getTime()));
            }
            int size = betweenTime.size() > max_range ? max_range : betweenTime.size();
            indices = betweenTime.toArray(new String[size]);
        }
        catch (Exception e) {
            return INDEX_PRE + outFormat.format(System.currentTimeMillis());
        }
        return String.join((CharSequence)",", indices);
    }
}

