/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.log.datasource;

import java.util.ArrayList;
import java.util.List;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.eye.api.log.datasource.LogDataSourceInfo;
import kd.bos.instance.Instance;
import kd.bos.util.ConfigurationUtil;
import kd.bos.util.JSONUtils;
import kd.bos.util.StringUtils;

public class LogDataSourceManager {
    private static final String MONITOR_ES_CONFIG = "monitor.es.config";
    private static final String ES_USERNAME = "monitor.es.user";
    private static final String ES_PD = "monitor.es.password";
    private static final String ES_SSL_ENABLE = "monitor.es.ssl.enable";
    private static final String ES_CERTIFICATE_PATH = "monitor.es.certificate.path";
    private static final String ES_CERTIFICATE_PD = "monitor.es.certificate.password";
    private static final String INDEX_PRE = Instance.getClusterName() + "-log-";
    private static final String ALL_IN_ONE = "AllInOne";
    public static final String ALL_DATASOURCE_QUERY = "AllDataSourceQuery";
    private static List<LogDataSourceInfo> logDataSourceInfos = null;

    private static void initListener() {
        ConfigurationUtil.observeChange((String)MONITOR_ES_CONFIG, (key, newValue) -> {
            try {
                logDataSourceInfos = LogDataSourceManager.parse(String.valueOf(newValue));
            }
            catch (Exception e) {
                logDataSourceInfos = null;
            }
        });
    }

    public static List<LogDataSourceInfo> getDataSourcesByNumber(String number) {
        ArrayList<LogDataSourceInfo> logDataSourceInfos = new ArrayList<LogDataSourceInfo>(1);
        if (!LogDataSourceManager.isMuiltDataSource()) {
            logDataSourceInfos.add(LogDataSourceManager.getAllInOneLogDataSource());
            return logDataSourceInfos;
        }
        if (StringUtils.isEmpty((String)number) || ALL_DATASOURCE_QUERY.equalsIgnoreCase(number)) {
            return LogDataSourceManager.getMuiltDataSources();
        }
        for (LogDataSourceInfo logDataSourceInfo : LogDataSourceManager.getMuiltDataSources()) {
            if (!logDataSourceInfo.getNumber().equals(number)) continue;
            logDataSourceInfos.add(logDataSourceInfo);
            return logDataSourceInfos;
        }
        throw new KDException(BosErrorCode.bOS, new Object[]{"unsupported multi log data source number." + number});
    }

    @Deprecated
    public static LogDataSourceInfo getDataSourceByNumber(String number) {
        return LogDataSourceManager.getDataSourcesByNumber(number).get(0);
    }

    public static List<LogDataSourceInfo> getMuiltDataSources() {
        if (!LogDataSourceManager.isMuiltDataSource()) {
            return new ArrayList<LogDataSourceInfo>();
        }
        if (logDataSourceInfos == null) {
            logDataSourceInfos = LogDataSourceManager.parse(System.getProperty(MONITOR_ES_CONFIG));
        }
        return logDataSourceInfos;
    }

    private static boolean isMuiltDataSource() {
        return StringUtils.isNotEmpty((String)System.getProperty(MONITOR_ES_CONFIG, "").trim());
    }

    private static List<LogDataSourceInfo> parse(String value) {
        List dataSourceInfoList = null;
        try {
            dataSourceInfoList = (List)JSONUtils.cast((String)value, (boolean)true, ArrayList.class, (Class[])new Class[]{LogDataSourceInfo.class});
            for (LogDataSourceInfo logDataSourceInfo : dataSourceInfoList) {
                if (StringUtils.isEmpty((String)logDataSourceInfo.getIndex())) {
                    logDataSourceInfo.setIndex(INDEX_PRE);
                }
                if (!StringUtils.isEmpty((String)logDataSourceInfo.getName()) && !StringUtils.isEmpty((String)logDataSourceInfo.getNumber())) continue;
                throw new KDException(BosErrorCode.bOS, new Object[]{"name/number can not be null!"});
            }
        }
        catch (Exception e) {
            throw new KDException(BosErrorCode.bOS, "parse monitor.es.config error!", (Throwable)e);
        }
        return dataSourceInfoList;
    }

    private static LogDataSourceInfo getAllInOneLogDataSource() {
        String url = System.getProperty("monitor.es.url");
        String indexPre = System.getProperty("monitor.es.index", INDEX_PRE);
        String username = System.getProperty(ES_USERNAME);
        String password = System.getProperty(ES_PD);
        Boolean isSslEnable = Boolean.parseBoolean(System.getProperty(ES_SSL_ENABLE));
        String path = System.getProperty(ES_CERTIFICATE_PATH);
        String certificatePwd = System.getProperty(ES_CERTIFICATE_PD);
        LogDataSourceInfo info = new LogDataSourceInfo();
        info.setName(ALL_IN_ONE);
        info.setNumber(ALL_IN_ONE);
        info.setUrl(url);
        info.setIndex(indexPre);
        info.setUs(username);
        info.setPp(password);
        info.setSslEnable(isSslEnable);
        info.setCertificatePath(path);
        info.setCertificatePP(certificatePwd);
        return info;
    }

    static {
        LogDataSourceManager.initListener();
    }
}

