/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.log.ruleconfig;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import kd.bos.config.client.util.JSONUtils;
import kd.bos.eye.api.log.ruleconfig.LogRuleExecuteStatus;
import kd.bos.eye.api.log.ruleconfig.LogRuleParamVo;
import kd.bos.eye.api.log.ruleconfig.LogRuleVo;
import kd.bos.government.metadata.MetadataFactory;
import kd.bos.government.metadata.Request;
import kd.bos.government.metadata.Result;
import kd.bos.government.metadata.Statement;
import kd.bos.government.metadata.db.DBRequest;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;

public class LogRuleConfigDbHelper {
    private static final Log logger = LogFactory.getLog(LogRuleConfigDbHelper.class);
    private static final String PAGE_QUERY_SQL_SECTION = " FID,FCLUSTERNAME,FRULENAME,FRULEVALUE,FENABLESTATUS,FEXECUTESTATUS,FUPDATEUSER,TO_CHAR(fupdatetime,'YYYY-MM-DD HH24:MI:SS') as fupdatetime FROM T_MONITOR_LOG_RULE_CONFIG WHERE FCLUSTERNAME = ?";
    private static final String QUERY_SQL = "SELECT FID,FCLUSTERNAME,FRULENAME,FRULEVALUE,FENABLESTATUS,FEXECUTESTATUS,FUPDATEUSER,TO_CHAR(fupdatetime,'YYYY-MM-DD HH24:MI:SS') as fupdatetime FROM T_MONITOR_LOG_RULE_CONFIG WHERE FCLUSTERNAME = ?";

    public static boolean updateLogRule(LogRuleParamVo logRuleParamVo) {
        logRuleParamVo.setExecuteStatus(LogRuleConfigDbHelper.getExecuteStatus(logRuleParamVo));
        DBRequest dbRequest = LogRuleConfigDbHelper.creatDBRequest(logRuleParamVo);
        Statement statement = MetadataFactory.getStatement();
        switch (logRuleParamVo.getRequestType()) {
            case 1: {
                return statement.executeInsert((Request)dbRequest) > 0;
            }
            case 2: {
                return statement.executeUpdate((Request)dbRequest) > 0;
            }
            case 3: {
                return statement.executeDelete((Request)dbRequest) > 0;
            }
        }
        return false;
    }

    public static List<LogRuleVo> getRuleByStatus(String enableStatus, String[] executeStatus) {
        return LogRuleConfigDbHelper.getLogRuleVoByMultiParam(null, enableStatus, executeStatus);
    }

    public static List<LogRuleVo> getLogRuleVoByMultiParam(String ruleName, String enableStatus, String[] executeStatus) {
        List<LogRuleVo> logRuleVoList;
        try {
            List<Result> results = LogRuleConfigDbHelper.getRuleByMultiParam(ruleName, enableStatus, executeStatus, null, null, 0, 0);
            logRuleVoList = new ArrayList<LogRuleVo>(results.size());
            for (Result result : results) {
                try {
                    String ruleValue = result.getString("frulevalue");
                    logRuleVoList.add((LogRuleVo)JSONUtils.cast((String)ruleValue, LogRuleVo.class, (boolean)true));
                }
                catch (Exception e) {
                    logger.error("Unsuccessful deserialization of logRuleVo", (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            logRuleVoList = Collections.emptyList();
            logger.error("getLogRuleVoByMultiParam error. ", (Throwable)e);
        }
        return logRuleVoList;
    }

    public static List<LogRuleParamVo> getLogRuleParamVoByMultiParam(String ruleName, String enableStatus, String[] executeStatus, LocalDateTime startDate, LocalDateTime endDate, int page, int size) {
        List<LogRuleParamVo> logRuleParamVoList;
        try {
            List<Result> results = LogRuleConfigDbHelper.getRuleByMultiParam(ruleName, enableStatus, executeStatus, startDate, endDate, page, size);
            logRuleParamVoList = new ArrayList<LogRuleParamVo>(results.size());
            for (Result result : results) {
                LogRuleParamVo logRuleParamVo = new LogRuleParamVo();
                logRuleParamVo.setId(result.getString("fid"));
                logRuleParamVo.setClusterName(Instance.getClusterName());
                logRuleParamVo.setRuleName(result.getString("frulename"));
                try {
                    String ruleValue = result.getString("frulevalue");
                    LogRuleVo logRuleVo = (LogRuleVo)JSONUtils.cast((String)ruleValue, LogRuleVo.class, (boolean)true);
                    logRuleParamVo.setRuleValueJson(ruleValue);
                    logRuleParamVo.setEffectiveDate(logRuleVo.getEffectiveDate());
                    logRuleParamVo.setEffectiveDuration(logRuleVo.getEffectiveDuration());
                }
                catch (Exception e) {
                    logger.error("Unsuccessful deserialization of log config rules", (Throwable)e);
                }
                logRuleParamVo.setEnableStatus(result.getString("fenablestatus"));
                logRuleParamVo.setExecuteStatus(result.getString("fexecutestatus"));
                logRuleParamVo.setUpdateTime(result.getString("fupdatetime"));
                logRuleParamVo.setUpdateUser(result.getString("fupdateuser"));
                logRuleParamVoList.add(logRuleParamVo);
            }
        }
        catch (Exception e) {
            logRuleParamVoList = Collections.emptyList();
            logger.error("getLogRuleParamVoByMultiParam error. ", (Throwable)e);
        }
        return logRuleParamVoList;
    }

    private static List<Result> getRuleByMultiParam(String ruleName, String enableStatus, String[] executeStatuArr, LocalDateTime startDate, LocalDateTime endDate, int page, int size) {
        boolean isContainEmpty;
        StringBuilder queryStringBuilder = new StringBuilder();
        if (page > 0 && size > 0) {
            int offset = (page - 1) * size;
            queryStringBuilder.append("select top ").append(size).append(',').append(offset).append(PAGE_QUERY_SQL_SECTION);
        } else {
            queryStringBuilder.append(QUERY_SQL);
        }
        ArrayList<Object> values = new ArrayList<Object>();
        values.add(Instance.getClusterName());
        if (StringUtils.isNotEmpty((String)ruleName)) {
            queryStringBuilder.append(" AND FRULENAME LIKE ?");
            values.add("%" + ruleName + "%");
        }
        if (StringUtils.isNotEmpty((String)enableStatus)) {
            queryStringBuilder.append(" AND FENABLESTATUS = ?");
            values.add(enableStatus);
        }
        if (executeStatuArr != null && executeStatuArr.length > 0 && !(isContainEmpty = Arrays.stream(executeStatuArr).allMatch(StringUtils::isEmpty))) {
            queryStringBuilder.append(" AND FEXECUTESTATUS IN (").append(String.join((CharSequence)", ", Collections.nCopies(executeStatuArr.length, "?"))).append(")");
            values.addAll(Arrays.asList(executeStatuArr));
        }
        if (startDate != null) {
            queryStringBuilder.append(" AND FCREATETIME >= ?");
            values.add(startDate);
        }
        if (endDate != null) {
            queryStringBuilder.append(" AND FCREATETIME <= ?");
            values.add(endDate);
        }
        queryStringBuilder.append(" ORDER BY FCREATETIME DESC");
        DBRequest dbRequest = new DBRequest();
        dbRequest.setQueryRequest(new DBRequest.QueryRequest(queryStringBuilder.toString(), values));
        return MetadataFactory.getStatement().executeQuery((Request)dbRequest);
    }

    private static String getExecuteStatus(LogRuleParamVo logRuleParamVo) {
        if ("disable".equals(logRuleParamVo.getEnableStatus())) {
            return LogRuleExecuteStatus.DISABLE.getStatus();
        }
        return LogRuleConfigDbHelper.getExecuteStatusByEffectiveDate(logRuleParamVo);
    }

    private static String getExecuteStatusByEffectiveDate(LogRuleParamVo logRuleParamVo) {
        DateTimeFormatter originalFormat = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss[.SSSSSS][.SSSSS][.SSSS][.SSS][.SS][.S]");
        LocalDateTime effectiveStartDate = LocalDateTime.parse(logRuleParamVo.getEffectiveDate(), originalFormat);
        LocalDateTime effectiveEndDate = effectiveStartDate.plusMinutes(Integer.parseInt(logRuleParamVo.getEffectiveDuration()));
        LocalDateTime now = LocalDateTime.now();
        if (now.isBefore(effectiveStartDate)) {
            return LogRuleExecuteStatus.NOT_STARTED.getStatus();
        }
        if (now.isBefore(effectiveEndDate)) {
            return LogRuleExecuteStatus.EXECUTING.getStatus();
        }
        return LogRuleExecuteStatus.EXPIRED.getStatus();
    }

    public static void updateExecuteStatus() {
        try {
            List<LogRuleParamVo> logRuleParamVoList = LogRuleConfigDbHelper.getLogRuleParamVoByMultiParam(null, "enable", new String[]{LogRuleExecuteStatus.NOT_STARTED.getStatus(), LogRuleExecuteStatus.EXECUTING.getStatus()}, null, null, 0, 0);
            if (logRuleParamVoList.size() > 0) {
                ArrayList<DBRequest> requestList = new ArrayList<DBRequest>();
                for (LogRuleParamVo logRuleParamVo : logRuleParamVoList) {
                    logRuleParamVo.setRequestType(2);
                    String executeStatus = LogRuleConfigDbHelper.getExecuteStatusByEffectiveDate(logRuleParamVo);
                    if (executeStatus.equals(logRuleParamVo.getExecuteStatus())) continue;
                    logRuleParamVo.setExecuteStatus(executeStatus);
                    requestList.add(LogRuleConfigDbHelper.creatDBRequest(logRuleParamVo));
                }
                MetadataFactory.getStatement().executeUpdateBatch(requestList);
            }
        }
        catch (Exception e) {
            logger.error("updateExecuteStatus error. ", (Throwable)e);
        }
    }

    private static DBRequest creatDBRequest(LogRuleParamVo logRuleParamVo) {
        DBRequest dbRequest = new DBRequest();
        String id = logRuleParamVo.getId();
        switch (logRuleParamVo.getRequestType()) {
            case 1: {
                String insertSql = "insert into T_MONITOR_LOG_RULE_CONFIG values(?,?,?,?,?,?,?,?,?)";
                ArrayList insertList = new ArrayList(6);
                Collections.addAll(insertList, id, Instance.getClusterName(), logRuleParamVo.getRuleName(), logRuleParamVo.getRuleValueJson(), logRuleParamVo.getEnableStatus(), logRuleParamVo.getExecuteStatus(), logRuleParamVo.getUpdateUser(), LocalDateTime.now(), LocalDateTime.now());
                dbRequest.setInsertRequest(new DBRequest.InsertRequest(insertSql, insertList));
                return dbRequest;
            }
            case 2: {
                String updateSql = "update T_MONITOR_LOG_RULE_CONFIG set frulename= ?, frulevalue= ?, fenablestatus= ?, fexecutestatus= ?, FUPDATEUSER= ?, fupdatetime = ? where fid = ?";
                ArrayList updateList = new ArrayList(7);
                Collections.addAll(updateList, logRuleParamVo.getRuleName(), logRuleParamVo.getRuleValueJson(), logRuleParamVo.getEnableStatus(), logRuleParamVo.getExecuteStatus(), logRuleParamVo.getUpdateUser(), LocalDateTime.now(), id);
                dbRequest.setUpdateRequest(new DBRequest.UpdateRequest(updateSql, updateList));
                return dbRequest;
            }
            case 3: {
                String deleteSql = "delete from T_MONITOR_LOG_RULE_CONFIG where fid = ?";
                ArrayList deleteList = new ArrayList(1);
                Collections.addAll(deleteList, id);
                dbRequest.setDeleteRequest(new DBRequest.DeleteRequest(deleteSql, deleteList));
                return dbRequest;
            }
        }
        return dbRequest;
    }
}

