/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.log.ruleconfig;

import com.sun.net.httpserver.HttpExchange;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dc.api.model.Account;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.exception.KDException;
import kd.bos.eye.api.appinfo.EyeNodeInfo;
import kd.bos.eye.api.log.ruleconfig.LogRuleConfigDbHelper;
import kd.bos.eye.api.log.ruleconfig.LogRuleParamVo;
import kd.bos.eye.api.log.ruleconfig.LogRuleVo;
import kd.bos.eye.api.log.ruleconfig.LoggerRuleMgrService;
import kd.bos.eye.api.oplog.OpLogManager;
import kd.bos.eye.api.oplog.OpLogger;
import kd.bos.eye.api.oplog.OpType;
import kd.bos.eye.auth.EyeAuther;
import kd.bos.eye.auth.SessionStore;
import kd.bos.eye.config.service.EyeConfigService;
import kd.bos.eye.httpserver.AbstractHttpHandler;
import kd.bos.eye.service.EyeServerService;
import kd.bos.eye.util.ApiResponse;
import kd.bos.eye.util.ExchangeVueUtils;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.monitor.lang.LangRes;
import kd.bos.tenant.TenantInfo;
import kd.bos.util.JSONUtils;
import kd.bos.util.StringUtils;

public class LogRuleConfigHandler
extends AbstractHttpHandler {
    private static final Log log = LogFactory.getLog(LogRuleConfigHandler.class);
    private static final OpLogger OPLOGGER = OpLogManager.getLogger();

    @Override
    protected void handle0(HttpExchange exchange) throws IOException {
        ApiResponse response = new ApiResponse();
        try {
            LogRuleParamVo logRuleParamVo = ExchangeVueUtils.parseJsonFromPost(exchange, LogRuleParamVo.class);
            if (logRuleParamVo.getRequestType() != 0) {
                EyeConfigService configService;
                List<LogRuleParamVo> logRuleParamVos;
                if (StringUtils.isEmpty((String)logRuleParamVo.getId())) {
                    logRuleParamVo.setId(String.valueOf(ID.genLongId()));
                }
                if (StringUtils.isEmpty((String)logRuleParamVo.getEnableStatus())) {
                    logRuleParamVo.setEnableStatus("enable");
                }
                if (1 == logRuleParamVo.getRequestType()) {
                    List<LogRuleVo> logRuleVos = LogRuleConfigDbHelper.getLogRuleVoByMultiParam(logRuleParamVo.getRuleName(), null, null);
                    if (logRuleVos != null && logRuleVos.size() > 0) {
                        throw new KDException(LangRes.get((String)"LogRuleConfigHandler_1", (String)"RuleName: {0} already exists", (Object[])new Object[]{logRuleParamVo.getRuleName()}));
                    }
                } else if (2 == logRuleParamVo.getRequestType() && (logRuleParamVos = LogRuleConfigDbHelper.getLogRuleParamVoByMultiParam(logRuleParamVo.getRuleName(), null, null, null, null, 0, 0)) != null && logRuleParamVos.size() > 0) {
                    if (logRuleParamVos.size() > 1) {
                        throw new KDException(LangRes.get((String)"LogRuleConfigHandler_1", (String)"RuleName: {0} already exists", (Object[])new Object[]{logRuleParamVo.getRuleName()}));
                    }
                    if (!logRuleParamVos.get(0).getId().equals(logRuleParamVo.getId())) {
                        throw new KDException(LangRes.get((String)"LogRuleConfigHandler_1", (String)"RuleName: {0} already exists", (Object[])new Object[]{logRuleParamVo.getRuleName()}));
                    }
                }
                Map<String, String> userInfo = SessionStore.get().get(EyeAuther.getToken(exchange));
                logRuleParamVo.setUpdateUser(userInfo.get("user"));
                boolean result = LogRuleConfigDbHelper.updateLogRule(logRuleParamVo);
                if (result && (configService = LoggerRuleMgrService.getEyeConfigService()) != null) {
                    configService.saveConfig("updateTime", Long.toString(System.currentTimeMillis()));
                }
                logRuleParamVo.setEnableStatus("");
                logRuleParamVo.setExecuteStatus("");
                this.addOpLog(exchange, logRuleParamVo.getRequestType());
            }
            int page = logRuleParamVo.getPage();
            int size = logRuleParamVo.getSize() > 0 ? logRuleParamVo.getSize() : 50;
            String enableStatus = logRuleParamVo.getEnableStatus();
            String executeStatus = logRuleParamVo.getExecuteStatus();
            String searchRuleName = logRuleParamVo.getSearchKey();
            String startDateStr = logRuleParamVo.getStartDate() != null ? logRuleParamVo.getStartDate() : this.getMinusDays(30);
            String endDateStr = logRuleParamVo.getEndDate();
            DateTimeFormatter originalFormat = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss[.SSSSSS][.SSSSS][.SSSS][.SSS][.SS][.S]");
            LocalDateTime startDate = LocalDateTime.parse(startDateStr, originalFormat);
            LocalDateTime endDate = null;
            if (StringUtils.isNotEmpty((String)endDateStr)) {
                endDate = LocalDateTime.parse(endDateStr, originalFormat);
            }
            List<LogRuleParamVo> logRuleParamVoList = LogRuleConfigDbHelper.getLogRuleParamVoByMultiParam(searchRuleName, enableStatus, new String[]{executeStatus}, startDate, endDate, page, size);
            HashMap<String, Object> returnMap = new HashMap<String, Object>(2);
            returnMap.put("logRuleVoList", logRuleParamVoList);
            returnMap.put("appNames", this.getSortedNodeInfos());
            List<String> tenantIdsList = this.getAllTenantsByCurrentEnv();
            returnMap.put("tenantIds", tenantIdsList);
            returnMap.put("accountIds", this.getAccountIdByTenant(tenantIdsList));
            response.setCode(0);
            response.setData(returnMap);
        }
        catch (Exception e) {
            String errMsg = LangRes.get((String)"LogRuleConfigHandler_2", (String)"The error msg is {0},traceId is {1}", (Object[])new Object[]{e.getMessage(), RequestContext.get().getTraceId()});
            log.error(errMsg, (Throwable)e);
            response.setCode(-1);
            response.setMsg(errMsg);
        }
        this.writeJson(JSONUtils.toString(response), exchange);
    }

    private List<String> getAllTenantsByCurrentEnv() {
        List tenantInfoList = AccountUtils.getAllTenantsByCurrentEnv();
        ArrayList<String> tenantIds = new ArrayList<String>(1);
        if (!tenantInfoList.isEmpty()) {
            for (TenantInfo tenantInfo : tenantInfoList) {
                tenantIds.add(tenantInfo.getId());
            }
        }
        return tenantIds;
    }

    private Map<String, List<String>> getAccountIdByTenant(List<String> tenantIds) {
        Map<String, List<String>> map = tenantIds.stream().map(tenantId -> {
            List accountList = AccountUtils.getAllAccounts((String)tenantId);
            if (accountList != null && !accountList.isEmpty()) {
                List accountIds = accountList.stream().map(Account::getAccountId).collect(Collectors.toList());
                return new AbstractMap.SimpleEntry((String)tenantId, accountIds);
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        return map;
    }

    private String getMinusDays(int a) {
        LocalDateTime now = LocalDateTime.now();
        LocalDateTime oneHourBefore = now.minusDays(a);
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        return oneHourBefore.format(formatter);
    }

    private Set<String> getSortedNodeInfos() {
        ArrayList<EyeNodeInfo> list = EyeServerService.getAllEyeNodes();
        HashSet<String> appNames = new HashSet<String>(1);
        for (EyeNodeInfo nodeInfo : list) {
            appNames.add(nodeInfo.getAppName());
        }
        return appNames;
    }

    private void addOpLog(HttpExchange exchange, int requestType) {
        if (requestType == 1) {
            OPLOGGER.opLog(exchange, OpType.ADD, "Log rule config", "Add log rule");
        }
        if (requestType == 2) {
            OPLOGGER.opLog(exchange, OpType.EDIT, "Log rule config", "Modify log rule");
        }
        if (requestType == 3) {
            OPLOGGER.opLog(exchange, OpType.DELETE, "Log rule config", "Delete log rule");
        }
    }
}

