/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.loghealth.checker;

import java.util.List;
import kd.bos.eye.api.loghealth.entity.config.LogConfig;
import kd.bos.eye.api.loghealth.entity.config.LogConfigFactory;
import kd.bos.eye.api.loghealth.entity.result.ConfigCheckResult;
import kd.bos.eye.api.loghealth.entity.status.ConfigStatus;
import kd.bos.eye.api.loghealth.exception.IllegalConfigException;
import kd.bos.mservice.monitor.lang.LangRes;

public class ConfigCompleteChecker {
    public static ConfigCheckResult check() {
        ConfigCheckResult configCheckResult = new ConfigCheckResult();
        configCheckResult.setConfigStatus(ConfigStatus.CORRECT);
        configCheckResult.setMessage(ConfigStatus.CORRECT.getDesc());
        LogConfig logConfig = null;
        try {
            logConfig = LogConfigFactory.getLogConfig();
            if (!ConfigCompleteChecker.isConfigedKafkaOutput(logConfig)) {
                configCheckResult.setConfigStatus(ConfigStatus.ERROR);
                configCheckResult.setMessage(LangRes.get((String)"ConfigCompleteChecker_0", (String)"The log configuration item [log.config] does not have the configuration for writing logs to Kafka", (Object[])new Object[0]));
            }
        }
        catch (IllegalConfigException illegalConfigException) {
            configCheckResult.setConfigStatus(ConfigStatus.ERROR);
            configCheckResult.setMessage(illegalConfigException.getMessage());
        }
        if (logConfig != null) {
            logConfig.getLogEsConfig().setPassword("******");
            logConfig.getLogEsConfig().setCertPassword("******");
            logConfig.getLogstashConfig().setPassword("******");
        }
        configCheckResult.setLogConfig(logConfig);
        return configCheckResult;
    }

    private static boolean isConfigedKafkaOutput(LogConfig logConfig) {
        List<String> appenders = logConfig.getAppenders();
        return appenders.contains("kafka");
    }
}

