/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.loghealth.checker;

import java.util.ArrayList;
import java.util.List;
import kd.bos.eye.api.loghealth.entity.config.LogConfig;
import kd.bos.eye.api.loghealth.entity.config.LogConfigFactory;
import kd.bos.eye.api.loghealth.entity.config.LogESConfig;
import kd.bos.eye.api.loghealth.entity.result.ESCheckResult;
import kd.bos.eye.api.loghealth.entity.status.ESStatus;
import kd.bos.eye.api.loghealth.helper.es.ESHealthHelper;
import kd.bos.eye.api.loghealth.helper.es.SampleESHealthInfo;
import kd.bos.eye.api.loghealth.util.LogHealthUtils;

public class ESHealthChecker {
    public static ESCheckResult check() {
        LogConfig logConfig = LogConfigFactory.getLogConfig();
        LogESConfig logEsConfig = logConfig.getLogEsConfig();
        ESHealthHelper esHealthHelper = new ESHealthHelper(logEsConfig);
        ESCheckResult esCheckResult = new ESCheckResult();
        esCheckResult.setUrl(logEsConfig.getUrl());
        if (esHealthHelper.isShutdown()) {
            esCheckResult.setEsStatus(ESStatus.SHUTDOWN);
            esCheckResult.setMessage(ESStatus.SHUTDOWN.getDesc());
        } else {
            List<SampleESHealthInfo> sampleESHealthInfos = ESHealthChecker.getSampleESHealthInfos(esHealthHelper);
            ESStatus esStatus = ESHealthChecker.getESStatus(sampleESHealthInfos);
            esCheckResult.setEsStatus(esStatus);
            esCheckResult.setMessage(esStatus.getDesc());
            esCheckResult.setSampleESHealthInfos(sampleESHealthInfos);
        }
        return esCheckResult;
    }

    public static List<SampleESHealthInfo> getSampleESHealthInfos(ESHealthHelper esHealthHelper) {
        ArrayList<SampleESHealthInfo> sampleESHealthInfos = new ArrayList<SampleESHealthInfo>();
        sampleESHealthInfos.add(esHealthHelper.getSampleESHealthInfo());
        LogHealthUtils.waitForSomething(3000L);
        sampleESHealthInfos.add(esHealthHelper.getSampleESHealthInfo());
        return sampleESHealthInfos;
    }

    public static ESStatus getESStatus(List<SampleESHealthInfo> sampleESHealthInfos) {
        int start = 0;
        int end = sampleESHealthInfos.size() - 1;
        long diffIndicesDisk = sampleESHealthInfos.get(end).getDiskIndices() - sampleESHealthInfos.get(start).getDiskIndices();
        if (diffIndicesDisk > 0L) {
            return ESStatus.FINE;
        }
        return ESStatus.UNKNOWN;
    }
}

