/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.eye.api.loghealth.checker;

import java.util.ArrayList;
import java.util.List;
import kd.bos.eye.api.loghealth.entity.config.LogConfig;
import kd.bos.eye.api.loghealth.entity.config.LogConfigFactory;
import kd.bos.eye.api.loghealth.entity.config.LogstashConfig;
import kd.bos.eye.api.loghealth.entity.result.LogstashResult;
import kd.bos.eye.api.loghealth.entity.status.LogstashStatus;
import kd.bos.eye.api.loghealth.helper.logstash.LogstashHealthHelper;
import kd.bos.eye.api.loghealth.helper.logstash.SampleLogstashHealthInfo;
import kd.bos.eye.api.loghealth.util.LogHealthUtils;

public class LogstashHealthChecker {
    public static LogstashResult check() {
        LogConfig logConfig = LogConfigFactory.getLogConfig();
        LogstashConfig logstashConfig = logConfig.getLogstashConfig();
        LogstashHealthHelper logstashHealthHelper = new LogstashHealthHelper(logstashConfig);
        LogstashResult logstashResult = new LogstashResult();
        logstashResult.setUrl(logstashConfig.getUrl());
        try {
            if (logstashHealthHelper.isShutdown()) {
                logstashResult.setLogstashStatus(LogstashStatus.SHUTDOWN);
                logstashResult.setMessage(LogstashStatus.SHUTDOWN.getDesc());
            } else {
                List<SampleLogstashHealthInfo> sampleLogstashHealthInfos = LogstashHealthChecker.getSampleLogstashHealthInfos(logstashHealthHelper);
                LogstashStatus logstashStatus = LogstashHealthChecker.getLogstashStatus(sampleLogstashHealthInfos);
                logstashResult.setSampleLogstashHealthInfos(sampleLogstashHealthInfos);
                logstashResult.setLogstashStatus(logstashStatus);
                logstashResult.setMessage(logstashStatus.getDesc());
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return logstashResult;
    }

    private static List<SampleLogstashHealthInfo> getSampleLogstashHealthInfos(LogstashHealthHelper logstashHealthHelper) {
        ArrayList<SampleLogstashHealthInfo> sampleLogstashHealthInfos = new ArrayList<SampleLogstashHealthInfo>();
        sampleLogstashHealthInfos.add(logstashHealthHelper.getLogstashHealthInfo());
        LogHealthUtils.waitForSomething(3000L);
        sampleLogstashHealthInfos.add(logstashHealthHelper.getLogstashHealthInfo());
        return sampleLogstashHealthInfos;
    }

    private static LogstashStatus getLogstashStatus(List<SampleLogstashHealthInfo> sampleLogstashHealthInfos) {
        int start = 0;
        int end = sampleLogstashHealthInfos.size() - 1;
        long inDiff = sampleLogstashHealthInfos.get(end).getIn() - sampleLogstashHealthInfos.get(start).getIn();
        long outDiff = sampleLogstashHealthInfos.get(end).getOut() - sampleLogstashHealthInfos.get(start).getOut();
        long diff = sampleLogstashHealthInfos.get(end).getIn() - sampleLogstashHealthInfos.get(end).getOut();
        if (inDiff > 0L && outDiff > 0L && diff < 3000L) {
            return LogstashStatus.FINE;
        }
        if (diff >= 3000L) {
            return LogstashStatus.BACKLOG;
        }
        return LogstashStatus.UNKNOWN;
    }
}

